/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarReference;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class UpdatePowersMessage
extends MessageS2C {
    private final int entityId;
    private final List<class_2960> toRemove;
    private final List<class_2960> toAdd;
    private final List<Triple<EnergyBarReference, Integer, Integer>> energyBars;

    public UpdatePowersMessage(class_1309 livingEntity, List<class_2960> toRemove, List<class_2960> toAdd) {
        this.entityId = livingEntity.method_5628();
        this.toRemove = toRemove;
        this.toAdd = toAdd;
        this.energyBars = new ArrayList<Triple<EnergyBarReference, Integer, Integer>>();
        Optional<PowerHandler> opt = PowerManager.getPowerHandler(livingEntity);
        if (opt.isPresent()) {
            for (IPowerHolder holder : opt.get().getPowerHolders().values()) {
                for (EnergyBar energyBar : holder.getEnergyBars().values()) {
                    this.energyBars.add((Triple<EnergyBarReference, Integer, Integer>)Triple.of((Object)new EnergyBarReference(holder.getPower().getId(), energyBar.getConfiguration().getName()), (Object)energyBar.get(), (Object)energyBar.getMax()));
                }
            }
        }
    }

    public UpdatePowersMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        this.toRemove = buf.method_34066(class_2540::method_10810);
        this.toAdd = buf.method_34066(class_2540::method_10810);
        this.energyBars = buf.method_34066(buf1 -> {
            EnergyBarReference ref = EnergyBarReference.fromBuffer(buf1);
            int val = buf1.readInt();
            int max = buf1.readInt();
            return Triple.of((Object)ref, (Object)val, (Object)max);
        });
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.UPDATE_POWERS;
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.method_34062(this.toRemove, class_2540::method_10812);
        buf.method_34062(this.toAdd, class_2540::method_10812);
        buf.method_34062(this.energyBars, (buf1, pair) -> {
            ((EnergyBarReference)pair.getLeft()).toBuffer((class_2540)buf1);
            buf1.writeInt(((Integer)pair.getMiddle()).intValue());
            buf1.writeInt(((Integer)pair.getRight()).intValue());
        });
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        class_1297 class_12972;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null && (class_12972 = level.method_8469(this.entityId)) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            PowerManager manager = PowerManager.getInstance((class_1937)level);
            List<Power> toRemove = this.toRemove.stream().map(manager::getPower).filter(Objects::nonNull).toList();
            List<Power> toAdd = this.toAdd.stream().map(manager::getPower).filter(Objects::nonNull).toList();
            PowerManager.getPowerHandler(livingEntity).ifPresent(handler -> handler.removeAndAddPowers(toRemove, toAdd));
            for (Triple<EnergyBarReference, Integer, Integer> pair : this.energyBars) {
                EnergyBar bar = ((EnergyBarReference)pair.getLeft()).getEntry(livingEntity);
                if (bar == null) continue;
                bar.set((Integer)pair.getMiddle());
                bar.setMax((Integer)pair.getRight());
            }
        }
    }
}

