/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;

public class DefaultPowerHolder
implements IPowerHolder {
    public final class_1309 entity;
    private final Power power;
    private final ImmutableMap<String, AbilityInstance> abilityInstances;
    private final ImmutableMap<String, EnergyBar> energyBars;
    private IPowerValidator validator;

    public DefaultPowerHolder(class_1309 entity, Power power, IPowerValidator validator) {
        this.entity = entity;
        this.power = power;
        this.validator = validator;
        HashMap<String, AbilityInstance> abilities = new HashMap<String, AbilityInstance>();
        for (AbilityConfiguration ability : this.getPower().getAbilities()) {
            AbilityInstance entry = new AbilityInstance(ability, this);
            entry.id = ability.getId();
            abilities.put(ability.getId(), entry);
        }
        this.abilityInstances = ImmutableMap.copyOf(abilities);
        LinkedHashMap<String, EnergyBar> energyBars = new LinkedHashMap<String, EnergyBar>();
        for (EnergyBarConfiguration energyBar : this.getPower().getEnergyBars()) {
            energyBars.put(energyBar.getName(), new EnergyBar(this, energyBar));
        }
        this.energyBars = ImmutableMap.copyOf(energyBars);
    }

    @Override
    public Power getPower() {
        return this.power;
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    @Override
    public void fromNBT(class_2487 tag) {
        for (Map.Entry entry : this.abilityInstances.entrySet()) {
            if (!tag.method_10545((String)entry.getKey())) continue;
            class_2487 abData = tag.method_10562((String)entry.getKey());
            ((AbilityInstance)entry.getValue()).fromNBT(abData);
        }
        if (tag.method_10573("_EnergyBars", 10)) {
            class_2487 energies = tag.method_10562("_EnergyBars");
            for (String key : energies.method_10541()) {
                if (!this.energyBars.containsKey((Object)key)) continue;
                ((EnergyBar)this.energyBars.get((Object)key)).fromNBT(energies.method_10562(key));
            }
        }
    }

    @Override
    public class_2487 toNBT(boolean toDisk) {
        class_2487 tag = new class_2487();
        for (Map.Entry entry : this.abilityInstances.entrySet()) {
            class_2487 abData = ((AbilityInstance)entry.getValue()).toNBT(toDisk);
            tag.method_10566((String)entry.getKey(), (class_2520)abData);
        }
        class_2487 energies = new class_2487();
        for (Map.Entry entry : this.energyBars.entrySet()) {
            energies.method_10566((String)entry.getKey(), (class_2520)((EnergyBar)entry.getValue()).toNBT());
        }
        tag.method_10566("_EnergyBars", (class_2520)energies);
        return tag;
    }

    public ImmutableMap<String, AbilityInstance> getAbilities() {
        return this.abilityInstances;
    }

    public ImmutableMap<String, EnergyBar> getEnergyBars() {
        return this.energyBars;
    }

    @Override
    public void tick() {
        for (AbilityInstance abilityInstance : this.abilityInstances.values()) {
            abilityInstance.tick(this.entity, this);
        }
        if (!this.getEntity().method_37908().field_9236) {
            for (EnergyBar energyBar : this.energyBars.values()) {
                energyBar.tick(this.entity);
            }
        }
    }

    @Override
    public void firstTick() {
        this.abilityInstances.forEach((id, entry) -> entry.getConfiguration().getAbility().firstTick(this.entity, (AbilityInstance)entry, this, entry.isEnabled()));
    }

    @Override
    public void lastTick() {
        this.abilityInstances.forEach((id, entry) -> entry.getConfiguration().getAbility().lastTick(this.entity, (AbilityInstance)entry, this, entry.isEnabled()));
    }

    @Override
    public boolean isInvalid() {
        return this.power.isInvalid() || !this.validator.stillValid(this.entity, this.power);
    }

    @Override
    public void switchValidator(IPowerValidator validator) {
        this.validator = validator;
    }
}

