/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.json.GsonUtil;

public class Power {
    private final class_2960 id;
    private final class_2561 name;
    private final IIcon icon;
    private final List<AbilityConfiguration> abilities = new ArrayList<AbilityConfiguration>();
    private final List<EnergyBarConfiguration> energyBars = new ArrayList<EnergyBarConfiguration>();
    private final TextureReference background;
    private final TextureReference abilityBar;
    private final Color primaryColor;
    private final Color secondaryColor;
    private final boolean persistentData;
    private final boolean hidden;
    private final boolean allowBarShrinking;
    private final GuiDisplayType guiDisplayType;
    private boolean invalid = false;

    public Power(class_2960 id, class_2561 name, IIcon icon, TextureReference background, TextureReference abilityBar, Color primaryColor, Color secondaryColor, boolean persistentData, boolean hidden, boolean allowBarShrinking, GuiDisplayType guiDisplayType) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.background = background;
        this.abilityBar = abilityBar;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.persistentData = persistentData;
        this.hidden = hidden;
        this.allowBarShrinking = allowBarShrinking;
        this.guiDisplayType = guiDisplayType;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public Power addAbility(AbilityConfiguration configuration) {
        this.abilities.add(configuration);
        return this;
    }

    public Power addEnergyBar(EnergyBarConfiguration configuration) {
        this.energyBars.add(configuration);
        return this;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public List<AbilityConfiguration> getAbilities() {
        return this.abilities;
    }

    public List<EnergyBarConfiguration> getEnergyBars() {
        return this.energyBars;
    }

    public TextureReference getBackground() {
        return this.background;
    }

    public TextureReference getAbilityBarTexture() {
        return this.abilityBar;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public boolean hasPersistentData() {
        return this.persistentData;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean allowBarShrinking() {
        return this.allowBarShrinking;
    }

    public GuiDisplayType getGuiDisplayType() {
        return this.guiDisplayType;
    }

    public void toBuffer(class_2540 buf) {
        buf.method_10805(this.name);
        buf.method_10794(IconSerializer.serializeNBT(this.icon));
        buf.writeBoolean(this.background != null);
        if (this.background != null) {
            this.background.toBuffer(buf);
        }
        buf.writeBoolean(this.abilityBar != null);
        if (this.abilityBar != null) {
            this.abilityBar.toBuffer(buf);
        }
        buf.writeInt(this.primaryColor.getRGB());
        buf.writeInt(this.secondaryColor.getRGB());
        buf.writeBoolean(this.persistentData);
        buf.writeBoolean(this.hidden);
        buf.writeBoolean(this.allowBarShrinking);
        buf.writeInt(this.guiDisplayType.ordinal());
        buf.method_34062(this.abilities, (buf1, configuration) -> configuration.toBuffer((class_2540)buf1));
        buf.method_34062(this.energyBars, (friendlyByteBuf, energyBar) -> energyBar.toBuffer((class_2540)friendlyByteBuf));
    }

    public static Power fromBuffer(class_2960 id, class_2540 buf) {
        Power power = new Power(id, buf.method_10808(), IconSerializer.parseNBT(Objects.requireNonNull(buf.method_10798())), buf.readBoolean() ? TextureReference.fromBuffer(buf) : null, buf.readBoolean() ? TextureReference.fromBuffer(buf) : null, new Color(buf.readInt()), new Color(buf.readInt()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), GuiDisplayType.values()[buf.readInt()]);
        List configurations = buf.method_34066(AbilityConfiguration::fromBuffer);
        for (AbilityConfiguration configuration : configurations) {
            power.addAbility(configuration);
        }
        List energyBars = buf.method_34066(EnergyBarConfiguration::fromBuffer);
        for (EnergyBarConfiguration energyBar : energyBars) {
            power.addEnergyBar(energyBar);
        }
        return power;
    }

    public static Power fromJSON(class_2960 id, JsonObject json) {
        class_5250 name = class_2561.class_2562.method_10872((JsonElement)json.get("name"));
        TextureReference background = GsonUtil.getAsTextureReference(json, "background", null);
        TextureReference abilityBarTexture = GsonUtil.getAsTextureReference(json, "ability_bar_texture", null);
        GuiDisplayType displayType = GuiDisplayType.getByName(class_3518.method_15253((JsonObject)json, (String)"gui_display_type", (String)"auto"));
        if (displayType == null) {
            throw new JsonParseException("Unknown gui display type '" + class_3518.method_15253((JsonObject)json, (String)"gui_display_type", (String)"list") + "', must be either 'list' or 'tree'");
        }
        Power power = new Power(id, (class_2561)name, IconSerializer.parseJSON(json.get("icon")), background, abilityBarTexture, GsonUtil.getAsColor(json, "primary_color", new Color(210, 112, 49)), GsonUtil.getAsColor(json, "secondary_color", new Color(126, 97, 86)), class_3518.method_15258((JsonObject)json, (String)"persistent_data", (boolean)false), class_3518.method_15258((JsonObject)json, (String)"hidden", (boolean)false), class_3518.method_15258((JsonObject)json, (String)"allow_bar_shrinking", (boolean)true), displayType);
        if (class_3518.method_15294((JsonObject)json, (String)"abilities")) {
            JsonObject abilities = class_3518.method_15296((JsonObject)json, (String)"abilities");
            for (String key : abilities.keySet()) {
                power.addAbility(AbilityConfiguration.fromJSON(key, class_3518.method_15296((JsonObject)abilities, (String)key)));
            }
        }
        if (class_3518.method_15294((JsonObject)json, (String)"energy_bars")) {
            JsonObject energyBars = class_3518.method_15296((JsonObject)json, (String)"energy_bars");
            for (String key : energyBars.keySet()) {
                power.addEnergyBar(EnergyBarConfiguration.fromJson(key, class_3518.method_15296((JsonObject)energyBars, (String)key)));
            }
        }
        return power;
    }

    public static enum GuiDisplayType {
        AUTO("auto"),
        TREE("tree"),
        LIST("list");

        private final String name;

        private GuiDisplayType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static GuiDisplayType getByName(String name) {
            for (GuiDisplayType value : GuiDisplayType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

