/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_8111;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.DamageImmunityAbility;
import net.threetag.palladium.power.ability.FireAspectAbility;
import net.threetag.palladium.power.ability.NameChangeAbility;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.threetag.palladiumcore.util.PlayerUtil;

public class AbilityEventHandler
implements LivingEntityEvents.Hurt,
LivingEntityEvents.Attack,
PlayerEvents.NameFormat,
PlayerEvents.ChangedDimension {
    public static void init() {
        AbilityEventHandler handler = new AbilityEventHandler();
        LivingEntityEvents.ATTACK.register((Object)handler);
        LivingEntityEvents.HURT.register((Object)handler);
        PlayerEvents.NAME_FORMAT.register((Object)handler);
        PlayerEvents.CHANGED_DIMENSION.register((Object)handler);
    }

    public EventResult livingEntityHurt(class_1309 entity, class_1282 damageSource, AtomicReference<Float> amount) {
        if (damageSource.method_49708(class_8111.field_42340) && AbilityUtil.isTypeEnabled(entity, (Ability)Abilities.INTANGIBILITY.get())) {
            return EventResult.cancel();
        }
        for (AbilityInstance entry : AbilityUtil.getEnabledInstances(entity, (Ability)Abilities.DAMAGE_IMMUNITY.get())) {
            if (!DamageImmunityAbility.isImmuneAgainst(entry, damageSource)) continue;
            return EventResult.cancel();
        }
        if (damageSource.method_49708(class_8111.field_42345) && entity.method_6127().method_27306((class_1320)PalladiumAttributes.FALL_RESISTANCE.get())) {
            double resistance = entity.method_26825((class_1320)PalladiumAttributes.FALL_RESISTANCE.get());
            if (resistance == 100.0) {
                return EventResult.cancel();
            }
            amount.set(Float.valueOf((float)((double)amount.get().floatValue() * (1.0 / resistance))));
        }
        return EventResult.pass();
    }

    public EventResult livingEntityAttack(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 sourceEntity;
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1309 && AbilityUtil.isTypeEnabled(sourceEntity = (class_1309)class_12972, (Ability)Abilities.FIRE_ASPECT.get())) {
            boolean hasAddedExistingFire = false;
            int fireSeconds = 0;
            for (AbilityInstance entry : AbilityUtil.getEnabledInstances(sourceEntity, (Ability)Abilities.FIRE_ASPECT.get())) {
                int time = Math.max(entry.getProperty(FireAspectAbility.TIME), 0);
                if (!hasAddedExistingFire && entry.getProperty(FireAspectAbility.SHOULD_STACK_TIME).booleanValue()) {
                    fireSeconds = Math.min(fireSeconds + entity.method_20802() / 20, entry.getProperty(FireAspectAbility.MAX_TIME));
                    hasAddedExistingFire = true;
                }
                fireSeconds += time;
            }
            entity.method_5639(fireSeconds);
        }
        return this.livingEntityHurt(entity, damageSource, new AtomicReference<Float>(Float.valueOf(amount)));
    }

    public void playerNameFormat(class_1657 player, class_2561 username, AtomicReference<class_2561> displayName) {
        AbilityUtil.getEnabledInstances((class_1309)player, (Ability)Abilities.NAME_CHANGE.get()).stream().filter(ab -> ab.getProperty(NameChangeAbility.NAME_CACHED) != null).findFirst().ifPresent(ability -> displayName.set(ability.getProperty(NameChangeAbility.NAME_CACHED)));
    }

    public void playerChangedDimension(class_1657 player, class_5321<class_1937> destination) {
        PlayerUtil.refreshDisplayName((class_1657)player);
    }
}

