/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.RenderLayerProviderAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityUtil {
    @NotNull
    public static Collection<AbilityInstance> getInstances(class_1309 entity) {
        ArrayList<AbilityInstance> instances = new ArrayList<AbilityInstance>();
        PowerManager.getPowerHandler(entity).ifPresent(handler -> handler.getPowerHolders().values().stream().map(holder -> holder.getAbilities().values()).forEach(instances::addAll));
        return instances;
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEntries(class_1309 entity) {
        return AbilityUtil.getInstances(entity);
    }

    @NotNull
    public static Collection<AbilityInstance> getInstances(class_1309 entity, class_2960 abilityId) {
        if (!Ability.REGISTRY.containsKey(abilityId)) {
            return Collections.emptyList();
        }
        return AbilityUtil.getInstances(entity, (Ability)Ability.REGISTRY.get(abilityId));
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEntries(class_1309 entity, class_2960 abilityId) {
        return AbilityUtil.getInstances(entity, abilityId);
    }

    @NotNull
    public static Collection<AbilityInstance> getInstances(class_1309 entity, Ability ability) {
        ArrayList<AbilityInstance> instances = new ArrayList<AbilityInstance>();
        PowerManager.getPowerHandler(entity).ifPresent(handler -> handler.getPowerHolders().values().stream().map(holder -> holder.getAbilities().values().stream().filter(instance -> instance.getConfiguration().getAbility() == ability).collect(Collectors.toList())).forEach(instances::addAll));
        return instances;
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEntries(class_1309 entity, Ability ability) {
        return AbilityUtil.getInstances(entity, ability);
    }

    @NotNull
    public static Collection<AbilityInstance> getEnabledInstances(class_1309 entity) {
        ArrayList<AbilityInstance> instances = new ArrayList<AbilityInstance>();
        PowerManager.getPowerHandler(entity).ifPresent(handler -> {
            for (IPowerHolder holder : handler.getPowerHolders().values()) {
                Collection<AbilityInstance> values = holder.getAbilities().values();
                for (AbilityInstance value : values) {
                    if (!value.isEnabled()) continue;
                    instances.add(value);
                }
            }
        });
        return instances;
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEnabledEntries(class_1309 entity) {
        return AbilityUtil.getEnabledInstances(entity);
    }

    @NotNull
    public static Collection<AbilityInstance> getEnabledRenderLayerInstances(class_1309 entity) {
        ArrayList<AbilityInstance> instances = new ArrayList<AbilityInstance>();
        PowerManager.getPowerHandler(entity).ifPresent(handler -> {
            for (IPowerHolder holder : handler.getPowerHolders().values()) {
                Collection<AbilityInstance> values = holder.getAbilities().values();
                for (AbilityInstance value : values) {
                    if (!(value.getConfiguration().getAbility() instanceof RenderLayerProviderAbility) || !value.isEnabled()) continue;
                    instances.add(value);
                }
            }
        });
        return instances;
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEnabledRenderLayerEntries(class_1309 entity) {
        return AbilityUtil.getEnabledRenderLayerInstances(entity);
    }

    @NotNull
    public static Collection<AbilityInstance> getEnabledInstances(class_1309 entity, class_2960 abilityId) {
        if (!Ability.REGISTRY.containsKey(abilityId)) {
            return Collections.emptyList();
        }
        return AbilityUtil.getEnabledInstances(entity, (Ability)Ability.REGISTRY.get(abilityId));
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEnabledEntries(class_1309 entity, class_2960 abilityId) {
        return AbilityUtil.getEnabledInstances(entity, abilityId);
    }

    @NotNull
    public static Collection<AbilityInstance> getEnabledInstances(class_1309 entity, Ability ability) {
        ArrayList<AbilityInstance> instances = new ArrayList<AbilityInstance>();
        PowerManager.getPowerHandler(entity).ifPresent(handler -> handler.getPowerHolders().values().stream().map(holder -> holder.getAbilities().values().stream().filter(instance -> instance.isEnabled() && instance.getConfiguration().getAbility() == ability).collect(Collectors.toList())).forEach(instances::addAll));
        return instances;
    }

    @Deprecated
    @NotNull
    public static Collection<AbilityInstance> getEnabledEntries(class_1309 entity, Ability ability) {
        return AbilityUtil.getEnabledInstances(entity, ability);
    }

    @Nullable
    public static AbilityInstance getInstance(class_1309 entity, class_2960 powerId, String abilityKey) {
        Power power = PowerManager.getInstance(entity.method_37908()).getPower(powerId);
        if (power == null) {
            return null;
        }
        IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
        if (handler == null) {
            return null;
        }
        IPowerHolder holder = handler.getPowerHolder(power);
        if (holder == null) {
            return null;
        }
        return holder.getAbilities().get(abilityKey);
    }

    @Deprecated
    @Nullable
    public static AbilityInstance getEntry(class_1309 entity, class_2960 powerId, String abilityKey) {
        return AbilityUtil.getInstance(entity, powerId, abilityKey);
    }

    public static boolean isUnlocked(class_1309 entity, class_2960 powerId, String abilityKey) {
        AbilityInstance instance = AbilityUtil.getInstance(entity, powerId, abilityKey);
        return instance != null && instance.isUnlocked();
    }

    public static boolean isEnabled(class_1309 entity, class_2960 powerId, String abilityKey) {
        AbilityInstance instance = AbilityUtil.getInstance(entity, powerId, abilityKey);
        return instance != null && instance.isEnabled();
    }

    public static boolean isTypeUnlocked(class_1309 entity, Ability ability) {
        return AbilityUtil.getInstances(entity, ability).stream().anyMatch(AbilityInstance::isUnlocked);
    }

    public static boolean isTypeUnlocked(class_1309 entity, class_2960 abilityId) {
        if (!Ability.REGISTRY.containsKey(abilityId)) {
            return false;
        }
        return AbilityUtil.isTypeUnlocked(entity, (Ability)Ability.REGISTRY.get(abilityId));
    }

    public static boolean isTypeEnabled(class_1309 entity, Ability ability) {
        return AbilityUtil.getInstances(entity, ability).stream().anyMatch(AbilityInstance::isEnabled);
    }

    public static boolean isTypeEnabled(class_1309 entity, class_2960 abilityId) {
        if (!Ability.REGISTRY.containsKey(abilityId)) {
            return false;
        }
        return AbilityUtil.isTypeEnabled(entity, (Ability)Ability.REGISTRY.get(abilityId));
    }

    public static boolean hasPower(class_1309 entity, class_2960 powerId) {
        Power power = PowerManager.getInstance(entity.method_37908()).getPower(powerId);
        if (power == null) {
            return false;
        }
        IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
        if (handler == null) {
            return false;
        }
        return handler.getPowerHolder(power) != null;
    }
}

