/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.threetag.palladium.client.particleemitter.ParticleEmitterConfiguration;
import net.threetag.palladium.client.particleemitter.ParticleEmitterManager;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ParticleTypeProperty;
import net.threetag.palladium.util.property.ResourceLocationListProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ParticleAbility
extends Ability {
    public static final PalladiumProperty<List<class_2960>> PARTICLE_EMITTER = new ResourceLocationListProperty("emitter").configurable("Configuration for where the particle spawns at. Check wiki for information.");
    public static final PalladiumProperty<class_2396<?>> PARTICLE = new ParticleTypeProperty("particle_type").configurable("ID of the particle you want to spawn.");
    public static final PalladiumProperty<String> OPTIONS = new StringProperty("options").configurable("Additional options for the particle (like color of a dust particle)");

    public ParticleAbility() {
        this.withProperty(PARTICLE_EMITTER, Collections.singletonList(new class_2960("example:emitter"))).withProperty(PARTICLE, class_2398.field_11212).withProperty(OPTIONS, "");
    }

    @Override
    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity.method_37908().field_9236) {
            this.tickClient(entity, entry);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tickClient(class_1309 entity, AbilityInstance entry) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            try {
                class_2396<?> type = entry.getProperty(PARTICLE);
                class_2394 options = type.method_10298().method_10296(type, new StringReader(" " + entry.getProperty(OPTIONS).trim() + " "));
                for (class_2960 id : entry.getProperty(PARTICLE_EMITTER)) {
                    ParticleEmitterConfiguration emitter = ParticleEmitterManager.INSTANCE.get(id);
                    if (emitter == null) continue;
                    emitter.spawnParticles(entity.method_37908(), player, options, class_310.method_1551().method_1534());
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }
}

