/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.renderer.entity.PlayerSkinHandler;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.ChangedPlayerModelTypeProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.SkinTypedTextureReferenceProperty;

public class SkinChangeAbility
extends Ability {
    public static final PalladiumProperty<SkinTypedValue<TextureReference>> TEXTURE = new SkinTypedTextureReferenceProperty("texture").configurable("Texture for the skin change");
    public static final PalladiumProperty<ChangedPlayerModelTypeProperty.ChangedModelType> MODEL_TYPE = new ChangedPlayerModelTypeProperty("model_type").configurable("Model type for the player. 'normal' = Wide-armed Steve model; 'slim' = Slim-armed Alex model; 'keep' = Does not change the player's default model");
    public static final PalladiumProperty<Integer> PRIORITY = new IntegerProperty("priority").configurable("Priority for the skin (in case multiple skin changes are applied, the one with the highest priority will be used)");

    public SkinChangeAbility() {
        this.withProperty(TEXTURE, new SkinTypedValue<TextureReference>(TextureReference.normal(new class_2960("textures/entity/zombie/drowned.png"))));
        this.withProperty(MODEL_TYPE, ChangedPlayerModelTypeProperty.ChangedModelType.KEEP);
        this.withProperty(PRIORITY, 50);
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows you to change a player's skin.";
    }

    @Environment(value=EnvType.CLIENT)
    public static class SkinProvider
    implements PlayerSkinHandler.ISkinProvider {
        @Override
        public PlayerSkinInfo getSkin(class_742 player, PlayerSkinInfo previousSkin, PlayerSkinInfo defaultSkin) {
            List<AbilityInstance> abilities = AbilityUtil.getEnabledInstances((class_1309)player, (Ability)Abilities.SKIN_CHANGE.get()).stream().filter(AbilityInstance::isEnabled).sorted((a1, a2) -> a2.getProperty(PRIORITY) - a1.getProperty(PRIORITY)).toList();
            if (!abilities.isEmpty()) {
                AbilityInstance ability = abilities.get(0);
                String model = ability.getProperty(MODEL_TYPE).getModelName();
                return new PlayerSkinInfo(model != null ? model : previousSkin.getModelName(), ability.getProperty(TEXTURE).get((class_1297)player).getTexture(DataContext.forAbility((class_1309)player, ability)));
            }
            return previousSkin;
        }
    }
}

