/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_5498;

public class PerspectiveValue<T> {
    private final T firstPerson;
    private final T thirdPerson;

    public PerspectiveValue(T value) {
        this.thirdPerson = value;
        this.firstPerson = this.thirdPerson;
    }

    public PerspectiveValue(T firstPerson, T thirdPerson) {
        this.firstPerson = firstPerson;
        this.thirdPerson = thirdPerson;
    }

    public T getFirstPerson() {
        return this.firstPerson;
    }

    public T getThirdPerson() {
        return this.thirdPerson;
    }

    public T get(boolean firstPerson) {
        return firstPerson ? this.getFirstPerson() : this.getThirdPerson();
    }

    @Environment(value=EnvType.CLIENT)
    public T get(class_5498 cameraType) {
        return this.get(cameraType == class_5498.field_26664);
    }

    @Environment(value=EnvType.CLIENT)
    public T get() {
        return this.get(class_310.method_1551().field_1690.method_31044());
    }

    @Environment(value=EnvType.CLIENT)
    public T getForPlayer(class_1657 player) {
        if (player == class_310.method_1551().field_1724) {
            return this.get();
        }
        return this.get(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerspectiveValue)) {
            return false;
        }
        PerspectiveValue that = (PerspectiveValue)o;
        return Objects.equals(this.firstPerson, that.firstPerson) && Objects.equals(this.thirdPerson, that.thirdPerson);
    }

    public int hashCode() {
        return Objects.hash(this.firstPerson, this.thirdPerson);
    }

    public String toString() {
        return "PerspectiveValue{firstPerson=" + String.valueOf(this.firstPerson) + ", thirdPerson=" + String.valueOf(this.thirdPerson) + "}";
    }

    public static <T> PerspectiveValue<T> fromJSON(JsonElement jsonElement, Function<JsonElement, T> parser) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (class_3518.method_15294((JsonObject)json, (String)"first_person") && class_3518.method_15294((JsonObject)json, (String)"third_person")) {
                return new PerspectiveValue<T>(parser.apply(json.get("first_person")), parser.apply(json.get("third_person")));
            }
            return new PerspectiveValue<T>(parser.apply(jsonElement));
        }
        return new PerspectiveValue<T>(parser.apply(jsonElement));
    }

    public static <T> PerspectiveValue<T> getFromJson(JsonObject json, String memberName, Function<JsonElement, T> parser, T fallback) {
        if (json.has(memberName)) {
            return PerspectiveValue.fromJSON(json.get(memberName), parser);
        }
        return new PerspectiveValue<T>(fallback);
    }

    public JsonElement toJson(Function<T, JsonElement> serializer) {
        if (this.firstPerson == this.thirdPerson) {
            return serializer.apply(this.firstPerson);
        }
        JsonObject json = new JsonObject();
        json.add("first_person", serializer.apply(this.firstPerson));
        json.add("third_person", serializer.apply(this.thirdPerson));
        return json;
    }
}

