/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static <T> void ifNotNull(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static void ifTrue(Boolean bool, Runnable runnable) {
        if (bool != null && bool.booleanValue()) {
            runnable.run();
        }
    }

    @NotNull
    public static <T> T orElse(@Nullable T val, T def) {
        return val != null ? val : def;
    }

    @NotNull
    public static <T> T orElse(@Nullable T val, Supplier<T> def) {
        return val != null ? val : def.get();
    }

    public static String getFormattedNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }
}

