/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TexturedIcon
implements IIcon {
    public static final class_2960 LOCK = new class_2960("palladium", "textures/icons/lock.png");
    public final TextureReference texture;
    public final Color tint;

    public TexturedIcon(TextureReference texture) {
        this(texture, null);
    }

    public TexturedIcon(TextureReference texture, Color tint) {
        this.texture = texture;
        this.tint = tint;
    }

    public TexturedIcon(class_2960 texture) {
        this(texture, null);
    }

    public TexturedIcon(class_2960 texture, Color tint) {
        this(TextureReference.normal(texture), tint);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int w, int h) {
        class_4587 stack = guiGraphics.method_51448();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture.getTexture(context));
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        Matrix4f m = stack.method_23760().method_23761();
        Color color = this.tint != null ? this.tint : Color.WHITE;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_22913(1.0f, 0.0f).method_1344();
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(0.0f, 0.0f).method_1344();
        tesselator.method_1350();
    }

    public IconSerializer<TexturedIcon> getSerializer() {
        return (IconSerializer)IconSerializers.TEXTURE.get();
    }

    public String toString() {
        return "TexturedIcon{texture=" + String.valueOf(this.texture) + ", tint=" + String.valueOf(this.tint) + "}";
    }

    public static class Serializer
    extends IconSerializer<TexturedIcon> {
        @Override
        @NotNull
        public TexturedIcon fromJSON(JsonObject json) {
            TextureReference texture = TextureReference.parse(class_3518.method_15265((JsonObject)json, (String)"texture"));
            Color tint = null;
            if (class_3518.method_15294((JsonObject)json, (String)"tint")) {
                int[] color = GsonUtil.getIntArray(json, 3, "tint", 255, 255, 255);
                tint = new Color(color[0], color[1], color[2]);
            }
            return new TexturedIcon(texture, tint);
        }

        @Override
        public TexturedIcon fromNBT(class_2487 nbt) {
            TextureReference texture = TextureReference.parse(nbt.method_10558("Texture"));
            Color tint = null;
            if (nbt.method_10545("ColorRed") && nbt.method_10545("ColorGreen") && nbt.method_10545("ColorBlue")) {
                tint = new Color(nbt.method_10550("ColorRed"), nbt.method_10550("ColorGreen"), nbt.method_10550("ColorBlue"));
            }
            return new TexturedIcon(texture, tint);
        }

        @Override
        public JsonObject toJSON(TexturedIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("texture", icon.texture.toString());
            if (icon.tint != null) {
                JsonArray array = new JsonArray();
                array.add((Number)icon.tint.getRed());
                array.add((Number)icon.tint.getGreen());
                array.add((Number)icon.tint.getBlue());
                jsonObject.add("tint", (JsonElement)array);
            }
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(TexturedIcon icon) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("Texture", icon.texture.toString());
            if (icon.tint != null) {
                nbt.method_10569("ColorRed", icon.tint.getRed());
                nbt.method_10569("ColorGreen", icon.tint.getGreen());
                nbt.method_10569("ColorBlue", icon.tint.getBlue());
            }
            return nbt;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Textured Icon");
            builder.setDescription("Uses a texture to render as an icon.");
            builder.addProperty("texture", TextureReference.class).description("Path to the texture file or dynamic texture json file.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/icons/my_icon.png"));
            JsonArray tint = new JsonArray();
            tint.add((Number)123);
            tint.add((Number)32);
            tint.add((Number)212);
            builder.addProperty("tint", Integer[].class).description("Adds an additional tint to the texture.").fallback(new Integer[]{255, 255, 255}, "/").exampleJson((JsonElement)tint);
        }
    }
}

