/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ColorProperty
extends PalladiumProperty<Color> {
    public ColorProperty(String key) {
        super(key);
    }

    @Override
    public Color fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return Color.decode(jsonElement.getAsString());
        }
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            if (array.size() == 3) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            if (array.size() == 4) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
            }
            throw new JsonParseException("Color array must either have 3 (RGB) or 4 (RGBA) integers");
        }
        throw new JsonParseException("Color must either be defined as RGB-string or array of integers");
    }

    @Override
    public JsonElement toJSON(Color value) {
        if (value.getAlpha() != 255) {
            JsonArray array = new JsonArray();
            array.add((Number)value.getRed());
            array.add((Number)value.getGreen());
            array.add((Number)value.getBlue());
            array.add((Number)value.getAlpha());
            return array;
        }
        return new JsonPrimitive(String.format("#%02X%02X%02X", value.getRed(), value.getGreen(), value.getBlue()));
    }

    @Override
    public Color fromNBT(class_2520 tag, Color defaultValue) {
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            return new Color(compoundTag.method_10550("Red"), compoundTag.method_10550("Green"), compoundTag.method_10550("Blue"), compoundTag.method_10550("Alpha"));
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(Color value) {
        class_2487 tag = new class_2487();
        tag.method_10569("Red", value.getRed());
        tag.method_10569("Green", value.getGreen());
        tag.method_10569("Blue", value.getBlue());
        tag.method_10569("Alpha", value.getAlpha());
        return tag;
    }

    @Override
    public Color fromBuffer(class_2540 buf) {
        return new Color(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        Color color = (Color)value;
        buf.writeInt(color.getRed());
        buf.writeInt(color.getGreen());
        buf.writeInt(color.getBlue());
        buf.writeInt(color.getAlpha());
    }

    @Override
    public String getPropertyType() {
        return "color";
    }
}

