/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class TagKeyListProperty<T>
extends PalladiumProperty<List<class_6862<T>>> {
    private final class_5321<class_2378<T>> registry;

    public TagKeyListProperty(String key, class_5321<class_2378<T>> registry) {
        super(key);
        this.registry = registry;
    }

    @Override
    public List<class_6862<T>> fromJSON(JsonElement jsonElement) {
        return GsonUtil.fromListOrPrimitive(jsonElement, j -> class_6862.method_40092(this.registry, (class_2960)new class_2960(j.getAsString())));
    }

    @Override
    public JsonElement toJSON(List<class_6862<T>> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.get(0).comp_327().toString());
        }
        JsonArray array = new JsonArray();
        for (class_6862<T> tag : value) {
            array.add((JsonElement)new JsonPrimitive(tag.comp_327().toString()));
        }
        return array;
    }

    @Override
    public List<class_6862<T>> fromNBT(class_2520 tag, List<class_6862<T>> defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            ArrayList<class_6862<T>> list = new ArrayList<class_6862<T>>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(class_6862.method_40092(this.registry, (class_2960)new class_2960(listTag.method_10608(i))));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(List<class_6862<T>> value) {
        class_2499 listTag = new class_2499();
        for (class_6862<T> tag : value) {
            listTag.add((Object)class_2519.method_23256((String)tag.comp_327().toString()));
        }
        return listTag;
    }

    @Override
    public List<class_6862<T>> fromBuffer(class_2540 buf) {
        ArrayList<class_6862<T>> list = new ArrayList<class_6862<T>>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(class_6862.method_40092(this.registry, (class_2960)buf.method_10810()));
        }
        return list;
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        List list = (List)value;
        buf.writeInt(list.size());
        for (class_6862 tag : list) {
            buf.method_10812(tag.comp_327());
        }
    }

    @Override
    public String getString(List<class_6862<T>> value) {
        return value == null ? null : Arrays.toString(value.stream().map(t -> t.comp_327().toString()).toArray());
    }

    @Override
    public String getPropertyType() {
        return "tag_key_list";
    }
}

