/*
 * Decompiled with CFR 0.152.
 */
package net.athlantes.eatyourself.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.athlantes.eatyourself.config.Config;

public class ConfigManager {
    private static final Path CONFIG_PATH = Paths.get("config", "eat_yourself_config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Config config;

    public static Config get() {
        if (config == null) {
            ConfigManager.load();
        }
        return config;
    }

    public static synchronized void load() {
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                config = Config.defaultConfig();
                ConfigManager.save();
                return;
            }
            String json = new String(Files.readAllBytes(CONFIG_PATH));
            Config parsed = (Config)GSON.fromJson(json, Config.class);
            if (parsed == null) {
                config = Config.defaultConfig();
                ConfigManager.save();
            } else {
                config = parsed;
            }
        }
        catch (IOException e) {
            config = Config.defaultConfig();
            try {
                ConfigManager.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void save() throws IOException {
        Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        String json = GSON.toJson((Object)(config != null ? config : Config.defaultConfig()));
        Files.write(CONFIG_PATH, json.getBytes(), new OpenOption[0]);
    }
}

