/*
 * Decompiled with CFR 0.152.
 */
package net.athlantes.eatyourself.events;

import net.athlantes.eatyourself.config.ConfigManager;
import net.athlantes.eatyourself.init.ModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BleedingEventHandler {
    private static final String HAD_BLEED_FLAG = "eatYourselfHadBleedingBeforeMilk";
    private static final String BLED_AMPLIFIER = "eatYourselfBleedingAmplifier";

    @SubscribeEvent
    public static void onUseStart(LivingEntityUseItemEvent.Start event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (event.getItem().m_41720_() != Items.f_42455_) {
            return;
        }
        MobEffectInstance inst = entity.m_21124_((MobEffect)ModEffects.BLEEDING.get());
        if (inst != null) {
            entity.getPersistentData().m_128379_(HAD_BLEED_FLAG, true);
            entity.getPersistentData().m_128405_(BLED_AMPLIFIER, inst.m_19564_());
        }
    }

    @SubscribeEvent
    public static void onUseFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (event.getItem().m_41720_() != Items.f_42455_) {
            return;
        }
        if (!ConfigManager.get().clearOnlyWithItem) {
            entity.getPersistentData().m_128473_(HAD_BLEED_FLAG);
            entity.getPersistentData().m_128473_(BLED_AMPLIFIER);
            return;
        }
        if (entity.getPersistentData().m_128471_(HAD_BLEED_FLAG)) {
            int amp = entity.getPersistentData().m_128451_(BLED_AMPLIFIER);
            int BLEEDING_DURATION_TICKS = ConfigManager.get().bleedingInfinite ? Integer.MAX_VALUE : 72000 * Math.max(1, ConfigManager.get().bleedingFiniteHours);
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), BLEEDING_DURATION_TICKS, amp, false, true));
            entity.getPersistentData().m_128473_(HAD_BLEED_FLAG);
            entity.getPersistentData().m_128473_(BLED_AMPLIFIER);
        }
    }
}

