/*
 * Decompiled with CFR 0.152.
 */
package net.athlantes.eatyourself.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.athlantes.eatyourself.config.ConfigManager;
import net.athlantes.eatyourself.init.ModEnchantments;
import net.athlantes.eatyourself.init.ModGameRules;
import net.athlantes.eatyourself.procedures.KnifeUse;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class IronKnifeItem
extends Item {
    private static final String PVP_COOLDOWN_TAG = "eatYourselfPvpCutCooldown";

    public IronKnifeItem() {
        super(new Item.Properties().m_41503_(85));
    }

    public float m_8102_(ItemStack itemstack, BlockState blockstate) {
        return 1.0f;
    }

    public boolean m_6813_(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.m_41622_(1, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.m_41622_(2, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_9236_().m_5776_() && target instanceof Player) {
            int pvpCooldown;
            long last;
            boolean allow;
            Player victim = (Player)target;
            if (victim.m_20148_().equals(player.m_20148_())) {
                return super.m_6880_(stack, player, target, hand);
            }
            boolean cfgAllow = ConfigManager.get().allowPlayerCutting;
            boolean ruleAllow = player.m_9236_().m_46469_().m_46207_(ModGameRules.ALLOW_PLAYER_CUTTING);
            boolean bl = ConfigManager.get().pvpRequireBoth ? cfgAllow && ruleAllow : (allow = cfgAllow || ruleAllow);
            if (!allow) {
                return super.m_6880_(stack, player, target, hand);
            }
            if (ConfigManager.get().attackerMustSneak && !player.m_6144_()) {
                return super.m_6880_(stack, player, target, hand);
            }
            if (ConfigManager.get().victimMustSneak && !victim.m_6144_()) {
                return super.m_6880_(stack, player, target, hand);
            }
            long gameTime = player.m_9236_().m_46467_();
            if (gameTime - (last = player.getPersistentData().m_128454_(PVP_COOLDOWN_TAG)) < (long)(pvpCooldown = Math.max(0, ConfigManager.get().pvpCutCooldownTicks))) {
                return InteractionResult.FAIL;
            }
            player.getPersistentData().m_128356_(PVP_COOLDOWN_TAG, gameTime);
            int sharpBladeLevel = EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(ModEnchantments.SHARP_BLADE.get(), 0);
            KnifeUse.registerExternalCut((LevelAccessor)player.m_9236_(), victim, sharpBladeLevel);
            float damage = sharpBladeLevel > 0 ? ConfigManager.get().ironKnifeDamageSharp : ConfigManager.get().ironKnifeDamageBase;
            int meatCount = sharpBladeLevel > 0 ? ConfigManager.get().ironKnifeMeatSharp : ConfigManager.get().ironKnifeMeatBase;
            KnifeUse.applyKnifeEffects((LevelAccessor)player.m_9236_(), (Entity)victim, player, stack, damage, meatCount);
            player.getPersistentData().m_128356_("eatYourselfJustCutOther", gameTime);
            if (ConfigManager.get().resetSelfCountersAfterPvpCut) {
                player.getPersistentData().m_128405_("eatYourselfCutCount", 0);
                player.getPersistentData().m_128356_("eatYourselfLastCutTime", 0L);
                player.getPersistentData().m_128356_("eatYourselfCooldown", 0L);
            }
            return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        HitResult hit = entity.m_19907_(5.0, 0.0f, false);
        if (hit == null || hit.m_6662_() != HitResult.Type.ENTITY) {
            KnifeUse.execute((LevelAccessor)world, (Entity)entity);
        }
        return ar;
    }

    public int m_6473_() {
        return 1;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = new ItemStack((ItemLike)this);
        retval.m_41721_(itemstack.m_41773_() + 1);
        if (retval.m_41773_() >= retval.m_41776_()) {
            return ItemStack.f_41583_;
        }
        return retval;
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }
}

