/*
 * Decompiled with CFR 0.152.
 */
package net.athlantes.eatyourself.procedures;

import net.athlantes.eatyourself.config.ConfigManager;
import net.athlantes.eatyourself.init.ModEffects;
import net.athlantes.eatyourself.init.ModEnchantments;
import net.athlantes.eatyourself.init.ModItems;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.items.ItemHandlerHelper;
import org.joml.Vector3f;

public class KnifeUse {
    private static final String COOLDOWN_TAG = "eatYourselfCooldown";
    private static final String LAST_CUT_TAG = "eatYourselfLastCutTime";
    private static final String CUT_COUNT_TAG = "eatYourselfCutCount";
    private static final String JUST_CUT_OTHER_TAG = "eatYourselfJustCutOther";

    private static int getCutsToBleed() {
        return Math.max(1, ConfigManager.get().cutsToBleed);
    }

    private static int getCutWindowTicks() {
        return Math.max(1, ConfigManager.get().cutWindowTicks);
    }

    public static void registerExternalCut(LevelAccessor world, Player victim, int sharpBladeLevel) {
        KnifeUse.noteCutAndMaybeBleed(world, victim, sharpBladeLevel);
    }

    public static void execute(LevelAccessor world, Entity entity) {
        int selfCd;
        long lastUse;
        long l;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!ConfigManager.get().selfCutEnabled) {
            return;
        }
        if (world instanceof Level) {
            Level lvl = (Level)world;
            l = lvl.m_46467_();
        } else {
            l = world.m_8044_();
        }
        long gameTime = l;
        long justCut = player.getPersistentData().m_128454_(JUST_CUT_OTHER_TAG);
        if (justCut != 0L && gameTime - justCut < (long)ConfigManager.get().blockSelfCutAfterPvpTicks) {
            player.getPersistentData().m_128356_(JUST_CUT_OTHER_TAG, 0L);
            return;
        }
        if (player.m_6144_() && gameTime - (lastUse = player.getPersistentData().m_128454_(COOLDOWN_TAG)) >= (long)(selfCd = Math.max(0, ConfigManager.get().selfCutCooldownTicks))) {
            player.getPersistentData().m_128356_(COOLDOWN_TAG, gameTime);
            ItemStack heldItem = player.m_21205_();
            int sharpBladeLevel = EnchantmentHelper.m_44831_((ItemStack)heldItem).getOrDefault(ModEnchantments.SHARP_BLADE.get(), 0);
            if (heldItem.m_150930_((Item)ModItems.IRON_KNIFE.get())) {
                float damage = sharpBladeLevel > 0 ? ConfigManager.get().ironKnifeDamageSharp : ConfigManager.get().ironKnifeDamageBase;
                int meat = sharpBladeLevel > 0 ? ConfigManager.get().ironKnifeMeatSharp : ConfigManager.get().ironKnifeMeatBase;
                KnifeUse.doKnifeEffects(world, (Entity)player, player, heldItem, damage, meat);
                KnifeUse.noteCutAndMaybeBleed(world, player, sharpBladeLevel);
            } else if (heldItem.m_150930_((Item)ModItems.DIAMOND_KNIFE.get())) {
                float damage = sharpBladeLevel > 0 ? ConfigManager.get().diamondKnifeDamageSharp : ConfigManager.get().diamondKnifeDamageBase;
                int meat = sharpBladeLevel > 0 ? ConfigManager.get().diamondKnifeMeatSharp : ConfigManager.get().diamondKnifeMeatBase;
                KnifeUse.doKnifeEffects(world, (Entity)player, player, heldItem, damage, meat);
                KnifeUse.noteCutAndMaybeBleed(world, player, sharpBladeLevel);
            }
            if (player.m_21223_() <= ConfigManager.get().confusionHealthThreshold) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, ConfigManager.get().confusionDurationTicks, 0, false, true));
            }
        }
    }

    public static void applyKnifeEffects(LevelAccessor world, Entity entity, Player player, ItemStack heldItem, float damage, int meatCount) {
        KnifeUse.doKnifeEffects(world, entity, player, heldItem, damage, meatCount);
    }

    private static void noteCutAndMaybeBleed(LevelAccessor world, Player player, int sharpBladeLevel) {
        long l;
        if (ConfigManager.get().preventWithSharpness && sharpBladeLevel > 0) {
            player.getPersistentData().m_128405_(CUT_COUNT_TAG, 0);
            return;
        }
        if (world instanceof Level) {
            Level lvl = (Level)world;
            l = lvl.m_46467_();
        } else {
            l = world.m_8044_();
        }
        long gameTime = l;
        long lastCut = player.getPersistentData().m_128454_(LAST_CUT_TAG);
        int count = player.getPersistentData().m_128451_(CUT_COUNT_TAG);
        int window = KnifeUse.getCutWindowTicks();
        count = gameTime - lastCut <= (long)window ? count + 1 : 1;
        player.getPersistentData().m_128356_(LAST_CUT_TAG, gameTime);
        player.getPersistentData().m_128405_(CUT_COUNT_TAG, count);
        int cutsNeeded = KnifeUse.getCutsToBleed();
        if (count >= cutsNeeded) {
            int amplifier = Math.max(0, count - cutsNeeded);
            int duration = ConfigManager.get().bleedingInfinite ? Integer.MAX_VALUE : 72000 * Math.max(1, ConfigManager.get().bleedingFiniteHours);
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), duration, amplifier, false, true));
        }
    }

    private static void doKnifeEffects(LevelAccessor world, Entity target, Player player, ItemStack heldItem, float damage, int meatCount) {
        int durabilityLoss;
        block7: {
            if (world instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)world;
                if (damage > 0.0f) {
                    DamageSource source = target == player ? sl.m_269111_().m_269264_() : sl.m_269111_().m_269075_(player);
                    target.m_6469_(source, damage);
                }
                int bursts = Math.max(0, ConfigManager.get().cutParticleBursts);
                for (int i = 0; i < bursts; ++i) {
                    double dx = (Math.random() - 0.5) * 0.3;
                    double dy = Math.random() * 0.5;
                    double dz = (Math.random() - 0.5) * 0.3;
                    sl.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.0f), 1.0f), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 1, dx, dy, dz, 0.0);
                }
            }
            if (ConfigManager.get().dropMeatOnCut && meatCount > 0) {
                ItemStack meat = new ItemStack((ItemLike)ModItems.RAW_PLAYER_MEAT.get(), meatCount);
                try {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)meat);
                }
                catch (Exception e) {
                    if (!(world instanceof ServerLevel)) break block7;
                    ServerLevel sl = (ServerLevel)world;
                    sl.m_7967_((Entity)new ItemEntity((Level)sl, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), meat));
                }
            }
        }
        if ((durabilityLoss = Math.max(0, ConfigManager.get().durabilityLossPerCut)) > 0) {
            heldItem.m_41622_(durabilityLoss, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
        }
    }
}

