/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.WidgetsMod;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class WidgetManager {
    static final ObjectArrayList<ModWidget> enabled = new ObjectArrayList();
    private static final ObjectArrayList<ModWidget> allWidgets = new ObjectArrayList();
    static Function<class_2960, File> saveFileFactory = id -> new File(class_310.method_1551().field_1697.getPath() + "/config/widgets/" + id.method_12836() + "/" + id.method_12832() + ".json");
    private static final Gson gson = new Gson();

    public static void register(ModWidget widget) {
        allWidgets.add((Object)widget);
        if (widget.getSettings().isEnabled()) {
            WidgetManager.enable(widget);
        }
    }

    public static ObjectArrayList<ModWidget> getEnabledWidgets() {
        return new ObjectArrayList(enabled);
    }

    public static ObjectArrayList<ModWidget> getAllWidgets() {
        return new ObjectArrayList(allWidgets);
    }

    public static void enable(ModWidget widget) {
        enabled.add((Object)widget);
    }

    public static void disable(ModWidget widget) {
        enabled.remove((Object)widget);
    }

    public static void saveWidgets(List<ModWidget> widgets) {
        for (ModWidget widget : widgets) {
            WidgetsMod.LOGGER.info("Saving widget {}", (Object)widget.getId());
            File saveFile = saveFileFactory.apply(widget.getId());
            try {
                if (saveFile.getParentFile().isDirectory() || saveFile.getParentFile().mkdirs()) {
                    if (saveFile.isFile() || saveFile.createNewFile()) {
                        FileWriter fw = new FileWriter(saveFile);
                        try {
                            JsonWriter jw = new JsonWriter((Writer)fw);
                            try {
                                Streams.write((JsonElement)widget.getSettings().saveState(), (JsonWriter)jw);
                                continue;
                            }
                            finally {
                                jw.close();
                                continue;
                            }
                        }
                        finally {
                            fw.close();
                            continue;
                        }
                    }
                    WidgetsMod.LOGGER.error("Could not create file: {}", (Object)saveFile.getPath());
                    continue;
                }
                WidgetsMod.LOGGER.error("Could not create directory: {}", (Object)saveFile.getParentFile().getPath());
            }
            catch (IOException e) {
                WidgetsMod.LOGGER.error("An I/O operation failed while saving widget {} ({})", (Object)widget, (Object)widget.getId());
                WidgetsMod.LOGGER.error(e.toString());
                for (StackTraceElement element : e.getStackTrace()) {
                    WidgetsMod.LOGGER.error(String.valueOf(element));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static JsonObject loadWidget(class_2960 id) {
        WidgetsMod.LOGGER.info("Loading widget data of {}", (Object)id);
        File saveFile = saveFileFactory.apply(id);
        if (!saveFile.isFile()) {
            return null;
        }
        try (FileReader fr = new FileReader(saveFile);){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)fr, JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            WidgetsMod.LOGGER.error("An I/O operation failed while loading widget {}", (Object)id);
            WidgetsMod.LOGGER.error(e.toString());
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                WidgetsMod.LOGGER.error(String.valueOf(element));
                ++n2;
            }
            return null;
        }
    }
}

