/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.ResizableWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.RGBAColorWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class ArmorHudWidget
extends ResizableWidget {
    private int padding = 1;
    private boolean showDurability = true;
    private DurabilityStyle durabilityStyle;
    protected class_1799 helmet;
    protected class_1799 chestplate;
    protected class_1799 leggings;
    protected class_1799 boots;
    protected boolean rainbow = false;
    protected int rainbowSpeed = 3;
    protected int backgroundColor = 0x50000000;
    protected int textColor = -1;

    public ArmorHudWidget(class_2960 id) {
        super(id, List.of(new IntSliderWidgetSetting("padding", (class_2561)class_2561.method_43471((String)"widgets.widgets.armorHud.padding"), 0, 2, 5), new ToggleWidgetSetting("show_durability", (class_2561)class_2561.method_43471((String)"widgets.widgets.armorHud.showDurability"), true), new RGBAColorWidgetSetting("backgroundcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.background"), 0, 0, 0, 80), new EnumWidgetSetting<DurabilityStyle>("durability_style", (class_2561)class_2561.method_43471((String)"widgets.widgets.armorHud.durabilityStyle"), DurabilityStyle.class, DurabilityStyle.NUMBER, DurabilityStyle::getDisplayName), new ToggleWidgetSetting("rainbow", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow"), false), new IntSliderWidgetSetting("rainbow_speed", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow.speed"), 1, 3, 10), new RGBAColorWidgetSetting("textcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textcolor"), 255, 255, 255, 255)));
        this.getSettings().optionById("durability_style").setShowCondition(() -> this.showDurability);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> this.rainbow);
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.rainbow);
    }

    @Override
    public void renderScaled(class_332 context, long measuringTimeNano, class_327 textRenderer, int posX, int posY) {
        context.method_25294(posX, posY, posX + this.width(), posY + this.height(), this.backgroundColor);
        if (this.helmet != null) {
            this.renderItem(context, measuringTimeNano, textRenderer, this.helmet, posX + this.padding, posY + this.padding);
        }
        if (this.chestplate != null) {
            this.renderItem(context, measuringTimeNano, textRenderer, this.chestplate, posX + this.padding, posY + 16 + this.padding);
        }
        if (this.leggings != null) {
            this.renderItem(context, measuringTimeNano, textRenderer, this.leggings, posX + this.padding, posY + 32 + this.padding);
        }
        if (this.boots != null) {
            this.renderItem(context, measuringTimeNano, textRenderer, this.boots, posX + this.padding, posY + 48 + this.padding);
        }
    }

    private void renderItem(class_332 context, long mt, class_327 textRenderer, class_1799 stack, int posX, int posY) {
        context.method_51445(stack, posX, posY);
        context.method_51431(textRenderer, stack, posX, posY);
        if (this.showDurability) {
            this.renderDurability(context, mt, textRenderer, stack, posX, posY);
        }
    }

    private void renderDurability(class_332 context, long mt, class_327 textRenderer, class_1799 stack, int posX, int posY) {
        Integer maxDamage = (Integer)stack.method_57824(class_9334.field_50072);
        if (maxDamage != null) {
            int damage = (Integer)stack.method_57825(class_9334.field_49629, (Object)0);
            String text = switch (this.durabilityStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> String.valueOf(maxDamage - damage);
                case 1 -> (maxDamage - damage) * 100 / maxDamage + "%";
            };
            context.method_51433(textRenderer, text, posX + 16 + this.padding, posY + 5, this.rainbow ? BasicTextWidget.rainbowColor(mt, this.rainbowSpeed) : this.textColor, true);
        }
    }

    @Override
    public void tick() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_1661 inventory = player.method_31548();
            this.helmet = inventory.method_5438(39);
            this.chestplate = inventory.method_5438(38);
            this.leggings = inventory.method_5438(37);
            this.boots = inventory.method_5438(36);
        } else {
            this.boots = null;
            this.leggings = null;
            this.chestplate = null;
            this.helmet = null;
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.armorHud");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.armorHud.description");
    }

    @Override
    public int width() {
        if (this.showDurability) {
            return 36 + this.padding * 3;
        }
        return 16 + this.padding * 2;
    }

    @Override
    public int height() {
        return 64 + this.padding * 2;
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.padding = ((IntSliderWidgetSetting)settings.optionById("padding")).getValue();
        this.showDurability = ((ToggleWidgetSetting)settings.optionById("show_durability")).getValue();
        this.durabilityStyle = (DurabilityStyle)((Object)((EnumWidgetSetting)settings.optionById("durability_style")).getValue());
        this.rainbow = ((ToggleWidgetSetting)settings.optionById("rainbow")).getValue();
        this.rainbowSpeed = ((IntSliderWidgetSetting)settings.optionById("rainbow_speed")).getValue();
        this.textColor = ((RGBAColorWidgetSetting)settings.optionById("textcolor")).getColor();
        this.backgroundColor = ((RGBAColorWidgetSetting)settings.optionById("backgroundcolor")).getColor();
    }

    public static enum DurabilityStyle {
        NUMBER,
        PERCENT;


        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("widgets.widgets.armorHud.durabilityStyle." + this.name().toLowerCase()));
        }
    }
}

