/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.utils.WidgetUtils;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9191;

public class BandwidthWidget
extends BasicTextWidget {
    private int t = 0;
    private boolean dynamicColor = false;
    private boolean hideInSingleplayer = false;
    private Unit unit = Unit.KB;

    public BandwidthWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("dynamic_color", (class_2561)class_2561.method_43471((String)"widgets.widgets.bandwidth.dynamicColor"), true), new ToggleWidgetSetting("hide_in_singleplayer", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.hideInSingleplayer"), false), new EnumWidgetSetting<Unit>("unit", (class_2561)class_2561.method_43471((String)"widgets.widgets.bandwidth.unit"), Unit.class, Unit.KB, unit -> class_2561.method_43470((String)unit.name))));
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.dynamicColor && !this.rainbow);
        this.getSettings().optionById("rainbow").setShowCondition(() -> !this.dynamicColor);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> !this.dynamicColor && this.rainbow);
    }

    @Override
    public void tickWidget() {
        boolean bl = this.shouldRender = !this.hideInSingleplayer || !WidgetUtils.isInSingleplayer();
        if (!this.shouldRender) {
            return;
        }
        float tickRate = WidgetUtils.getClientTickRate();
        ++this.t;
        if ((float)this.t >= tickRate) {
            this.t = 0;
            long avgBytesPerSecond = BandwidthWidget.getAvgBytesPerSecond(class_310.method_1551(), tickRate);
            this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)this.unit.sizeFormatter.apply(avgBytesPerSecond)));
            if (this.dynamicColor) {
                this.textColor = avgBytesPerSecond < 100000L ? -16711936 : (avgBytesPerSecond < 750000L ? -256 : -53200);
            }
        }
    }

    private static long getAvgBytesPerSecond(class_310 client, float tickRate) {
        class_9191 packetSizeLog = client.method_53526().method_53544();
        int logLength = packetSizeLog.method_56663();
        int avgCompileLength = (int)(3.0f * tickRate);
        long size = 0L;
        for (int i = logLength - 1; i > logLength - avgCompileLength && i >= 0; --i) {
            size += packetSizeLog.method_56659(i);
        }
        return (long)((float)size / (float)avgCompileLength * tickRate);
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.dynamicColor = ((ToggleWidgetSetting)settings.optionById("dynamic_color")).getValue();
        this.hideInSingleplayer = ((ToggleWidgetSetting)settings.optionById("hide_in_singleplayer")).getValue();
        this.unit = (Unit)((Object)((EnumWidgetSetting)settings.optionById("unit")).getValue());
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.bandwidth");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.bandwidth.description");
    }

    public static enum Unit {
        KB("kB", bytes -> {
            if (bytes > 1000L) {
                double kB = (double)(bytes / 100L) / 10.0;
                return kB + " kB/s";
            }
            return bytes + " B/s";
        }),
        KiB("KiB", bytes -> {
            if (bytes > 1000L) {
                double kB = (double)Math.round((double)bytes / 102.4) / 10.0;
                return kB + " KiB/s";
            }
            return bytes + " B/s";
        });

        public final String name;
        public final LongFunction<String> sizeFormatter;

        private Unit(String name, LongFunction<String> sizeFormatter) {
            this.name = name;
            this.sizeFormatter = sizeFormatter;
        }
    }
}

