/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettingOption;
import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.ResizableWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.RGBAColorWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public abstract class BasicTextWidget
extends ResizableWidget {
    protected class_2561 renderText = class_2561.method_43473();
    protected boolean shouldRender = true;
    private int textX = 0;
    private int textY = 0;
    private int padding = 0;
    private class_327 renderer = null;
    private boolean textShadow = true;
    protected boolean rainbow = false;
    private int rainbowSpeed = 3;
    protected static final int DEFAULT_WIDTH = 80;
    protected static final int DEFAULT_HEIGHT = 21;
    protected static final int DEFAULT_BACKGROUND_COLOR = new Color(0, 0, 0, 80).getRGB();
    protected static final int DEFAULT_TEXT_COLOR = new Color(255, 255, 255, 255).getRGB();
    protected int backgroundColor = DEFAULT_BACKGROUND_COLOR;
    protected int textColor = DEFAULT_TEXT_COLOR;
    protected int width = 80;
    protected int height = 21;
    protected TextAlignment textAlignment = TextAlignment.CENTER;
    protected TextStyle textStyle = TextStyle.PLAIN;

    private static ObjectArrayList<WidgetSettingOption> getCustomSettings(List<WidgetSettingOption> otherCustomOptions) {
        ObjectArrayList list = new ObjectArrayList(otherCustomOptions);
        list.add((Object)new RGBAColorWidgetSetting("backgroundcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.background"), 0, 0, 0, 80));
        list.add((Object)new ToggleWidgetSetting("rainbow", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow"), false));
        list.add((Object)new RGBAColorWidgetSetting("textcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textcolor"), 255, 255, 255, 255));
        list.add((Object)new IntSliderWidgetSetting("rainbow_speed", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow.speed"), 1, 3, 10));
        list.add((Object)new IntSliderWidgetSetting("width", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.width"), 10, 80, 240));
        list.add((Object)new IntSliderWidgetSetting("height", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.height"), 9, 21, 80));
        list.add((Object)new ToggleWidgetSetting("shadow", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textshadow"), true));
        list.add(new EnumWidgetSetting<TextAlignment>("alignment", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.alignment"), TextAlignment.class, TextAlignment.CENTER, TextAlignment::displayText));
        list.add((Object)new IntSliderWidgetSetting("padding", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.padding"), 0, 5, 20));
        list.add(new EnumWidgetSetting<TextStyle>("text_style", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textstyle"), TextStyle.class, TextStyle.PLAIN, TextStyle::displayText));
        return list;
    }

    protected BasicTextWidget(class_2960 id, List<WidgetSettingOption> otherCustomOptions) {
        super(id, (List<WidgetSettingOption>)BasicTextWidget.getCustomSettings(otherCustomOptions));
        this.getSettings().optionById("padding").setShowCondition(() -> this.textAlignment != TextAlignment.CENTER);
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.rainbow);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> this.rainbow);
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void renderScaled(class_332 context, long n, class_327 textRenderer, int posX, int posY) {
        if (!this.shouldRender) {
            return;
        }
        this.renderer = textRenderer;
        context.method_25294(posX, posY, posX + this.width(), posY + this.height(), this.backgroundColor);
        context.method_51439(textRenderer, this.renderText, posX + this.textX, posY + (this.textShadow ? this.textY : this.textY + 1), this.rainbow ? BasicTextWidget.rainbowColor(n, this.rainbowSpeed) : this.textColor, this.textShadow);
    }

    public static int rainbowColor(long n, float speed) {
        return Color.HSBtoRGB((float)n / 1.0E10f * speed, 1.0f, 1.0f);
    }

    @Override
    public final void tick() {
        this.tickWidget();
        if (this.renderer != null) {
            int textWidth = this.renderer.method_27525((class_5348)this.renderText);
            switch (this.textAlignment.ordinal()) {
                case 2: {
                    this.textX = this.padding;
                    break;
                }
                case 1: {
                    this.textX = this.width() / 2 - textWidth / 2;
                    break;
                }
                case 0: {
                    this.textX = this.width() - this.padding - textWidth;
                }
            }
        }
        this.textY = (this.height - 9) / 2;
    }

    protected void formatAndSetRenderText(class_2561 renderText) {
        this.renderText = this.textStyle != TextStyle.PLAIN ? (class_2561)this.textStyle.operator.apply(renderText) : renderText;
    }

    public abstract void tickWidget();

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.backgroundColor = ((RGBAColorWidgetSetting)settings.optionById("backgroundcolor")).getColor();
        this.textColor = ((RGBAColorWidgetSetting)settings.optionById("textcolor")).getColor();
        this.width = ((IntSliderWidgetSetting)settings.optionById("width")).getValue();
        this.height = ((IntSliderWidgetSetting)settings.optionById("height")).getValue();
        this.textAlignment = (TextAlignment)((Object)((EnumWidgetSetting)settings.optionById("alignment")).getValue());
        this.padding = ((IntSliderWidgetSetting)settings.optionById("padding")).getValue();
        this.textShadow = ((ToggleWidgetSetting)settings.optionById("shadow")).getValue();
        this.textStyle = (TextStyle)((Object)((EnumWidgetSetting)settings.optionById("text_style")).getValue());
        this.rainbow = ((ToggleWidgetSetting)settings.optionById("rainbow")).getValue();
        this.rainbowSpeed = ((IntSliderWidgetSetting)settings.optionById("rainbow_speed")).getValue();
    }

    public static enum TextAlignment {
        RIGHT("right"),
        CENTER("center"),
        LEFT("left");

        public final String key;

        private TextAlignment(String key) {
            this.key = key;
        }

        public class_2561 displayText() {
            return class_2561.method_43471((String)("widgets.widgets.basictext.alignment." + this.key));
        }
    }

    public static enum TextStyle {
        PLAIN("plain", UnaryOperator.identity()),
        SQUARE_BRACKETS("squareBrackets", t -> TextStyle.surround("[", t, "]")),
        PARENTHESES("parentheses", t -> TextStyle.surround("(", t, ")"));

        public final String key;
        public final UnaryOperator<class_2561> operator;

        private TextStyle(String key, UnaryOperator<class_2561> operator) {
            this.key = key;
            this.operator = operator;
        }

        public class_2561 displayText() {
            return class_2561.method_43471((String)("widgets.widgets.basictext.style." + this.key));
        }

        public static class_2561 surround(String prefix, class_2561 subject, String suffix) {
            return class_2561.method_43470((String)prefix).method_10852(subject).method_10852((class_2561)class_2561.method_43470((String)suffix));
        }
    }
}

