/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ClockWidget
extends BasicTextWidget {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss aa EEEE");

    public ClockWidget(class_2960 id) {
        super(id, List.of(new EnumWidgetSetting<TimeOption>("hour_format", (class_2561)class_2561.method_43471((String)"widgets.widgets.clock.hourFormat"), TimeOption.class, TimeOption.HOUR_24, timeOption -> class_2561.method_43471((String)("widgets.widgets.clock.hourFormat." + timeOption.key))), new ToggleWidgetSetting("show_seconds", (class_2561)class_2561.method_43471((String)"widgets.widgets.clock.showSeconds"), true), new EnumWidgetSetting<DateOption>("date_format", (class_2561)class_2561.method_43471((String)"widgets.widgets.clock.dateFormat"), DateOption.class, DateOption.NO_DATE, DateOption::getName), new EnumWidgetSetting<WeekOption>("week_format", (class_2561)class_2561.method_43471((String)"widgets.widgets.clock.weekFormat"), WeekOption.class, WeekOption.NO_DAY_OF_WEEK, WeekOption::getName)));
        ((IntSliderWidgetSetting)this.getSettings().optionById("width")).setMaxValue(400);
    }

    @Override
    public void tickWidget() {
        this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)this.dateFormat.format(Date.from(Instant.now()))));
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        Object datePattern = "HH:mm:ss";
        TimeOption timeOption = (TimeOption)((Object)((EnumWidgetSetting)settings.optionById("hour_format")).getValue());
        DateOption dateOption = (DateOption)((Object)((EnumWidgetSetting)settings.optionById("date_format")).getValue());
        WeekOption weekOption = (WeekOption)((Object)((EnumWidgetSetting)settings.optionById("week_format")).getValue());
        boolean showSeconds = ((ToggleWidgetSetting)settings.optionById("show_seconds")).getValue();
        if (timeOption == TimeOption.HOUR_24) {
            datePattern = showSeconds ? "HH:mm:ss" : "HH:mm";
        } else if (timeOption == TimeOption.AM_PM) {
            datePattern = showSeconds ? "hh:mm:ss aa" : "hh:mm aa";
        } else if (timeOption == TimeOption.NO_TIME) {
            datePattern = "";
        }
        if (dateOption.format != null) {
            datePattern = ((String)datePattern).isEmpty() ? dateOption.format + (String)datePattern : dateOption.format + " " + (String)datePattern;
        }
        if (weekOption.format != null) {
            datePattern = ((String)datePattern).isEmpty() ? weekOption.format + (String)datePattern : weekOption.format + ", " + (String)datePattern;
        }
        this.dateFormat = new SimpleDateFormat((String)datePattern);
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.clock");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.clock.description");
    }

    public static enum TimeOption {
        NO_TIME("none"),
        HOUR_24("24hour"),
        AM_PM("am_pm");

        public final String key;

        private TimeOption(String key) {
            this.key = key;
        }
    }

    public static enum DateOption {
        NO_DATE(null),
        FULL_MONTH_DAY("MMMM dd"),
        DAY_FULL_MONTH("dd. MMMM"),
        ABB_MONTH_DAY("MMM dd"),
        DAY_ABB_MONTH("dd. MMM"),
        MONTH_DAY("MM/dd"),
        MONTH_DAY_2("dd.MM"),
        FULL_MONTH_DAY_YEAR("MMMM dd, y"),
        ABB_MONTH_DAY_YEAR("MMM dd, y"),
        DAY_FULL_MONTH_YEAR("dd. MMMM y"),
        DAY_ABB_MONTH_YEAR("dd. MMM y"),
        MONTH_DAY_YEAR("MM/dd/y"),
        MONTH_DAY_YEAR_2("dd.MM.y");

        public final String format;

        private DateOption(String format) {
            this.format = format;
        }

        public class_2561 getName() {
            return this.format == null ? class_2561.method_43471((String)"widgets.widgets.clock.dateFormat.none") : class_2561.method_30163((String)new SimpleDateFormat(this.format).format(Date.from(Instant.now())));
        }
    }

    public static enum WeekOption {
        NO_DAY_OF_WEEK(null),
        ABBREVIATED("E"),
        FULL("EEEE");

        public final String format;

        private WeekOption(String format) {
            this.format = format;
        }

        public class_2561 getName() {
            return this.format == null ? class_2561.method_43471((String)"widgets.widgets.clock.weekFormat.none") : class_2561.method_30163((String)new SimpleDateFormat(this.format).format(Date.from(Instant.now())));
        }
    }
}

