/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class PlayTimeWidget
extends BasicTextWidget {
    private static final long startTime = System.nanoTime();
    private LabelStyle labelStyle = LabelStyle.NO_LABEL;

    public PlayTimeWidget(class_2960 id) {
        super(id, List.of(new EnumWidgetSetting<LabelStyle>("labelstyle", (class_2561)class_2561.method_43471((String)"widgets.widgets.playtime.labelStyle"), LabelStyle.class, LabelStyle.NO_LABEL, labelStyle -> class_2561.method_43471((String)("widgets.widgets.playtime.labelStyle." + labelStyle.key)))));
    }

    @Override
    public void tickWidget() {
        long timePlayedMs = PlayTimeWidget.getPlayedMs();
        this.formatAndSetRenderText((class_2561)(switch (this.labelStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2561.method_43470((String)this.msToTimeStr(timePlayedMs));
            case 1 -> class_2561.method_43470((String)class_2561.method_43469((String)"widgets.widgets.playtime.playtime", (Object[])new Object[]{this.msToTimeStr(timePlayedMs)}).getString());
            case 2 -> class_2561.method_43470((String)class_2561.method_43469((String)"widgets.widgets.playtime.played", (Object[])new Object[]{this.msToTimeStr(timePlayedMs)}).getString());
        }));
    }

    private static long getPlayedMs() {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private String msToTimeStr(long timePlayedMs) {
        long seconds = timePlayedMs / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return this.formatTimeNumber(hours) + ":" + this.formatTimeNumber(minutes % 60L) + ":" + this.formatTimeNumber(seconds % 60L);
    }

    private String formatTimeNumber(long l) {
        return l < 10L ? "0" + l : String.valueOf(l);
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.playtime");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.playtime.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.labelStyle = (LabelStyle)((Object)((EnumWidgetSetting)settings.optionById("labelstyle")).getValue());
    }

    public static enum LabelStyle {
        NO_LABEL("none"),
        PLAYTIME("playtime"),
        PLAYED("played");

        public final String key;

        private LabelStyle(String key) {
            this.key = key;
        }
    }
}

