/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.utils.WidgetUtils;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class SpeedWidget
extends BasicTextWidget {
    private Unit unit = Unit.METERS_PER_SECOND;
    private boolean withXVelocity = true;
    private boolean withYVelocity = false;
    private boolean withZVelocity = true;
    private int digitsAfterComma = 1;
    private double[] averagingWindow = new double[10];
    private int windowPointer = 0;
    private class_243 lastPos = new class_243(0.0, 0.0, 0.0);

    public SpeedWidget(class_2960 id) {
        super(id, List.of(new EnumWidgetSetting<Unit>("unit", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.unit"), Unit.class, Unit.METERS_PER_SECOND, unit -> class_2561.method_30163((String)unit.displayName)), new ToggleWidgetSetting("with_x", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.withX"), true), new ToggleWidgetSetting("with_y", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.withY"), false), new ToggleWidgetSetting("with_z", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.withZ"), true), new IntSliderWidgetSetting("digits", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.digits"), 0, 1, 3), new IntSliderWidgetSetting("window_size", (class_2561)class_2561.method_43471((String)"widgets.widgets.speed.windowSize"), 3, 10, 60)));
    }

    @Override
    public void tickWidget() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_243 lastPos = this.lastPos;
            class_243 newPos = this.lastPos = player.method_19538();
            class_243 velocity = lastPos.method_1020(newPos);
            double rt = 0.0;
            if (this.withXVelocity) {
                rt += velocity.method_10216() * velocity.method_10216();
            }
            if (this.withYVelocity) {
                rt += velocity.method_10214() * velocity.method_10214();
            }
            if (this.withZVelocity) {
                rt += velocity.method_10215() * velocity.method_10215();
            }
            this.averagingWindow[this.windowPointer++] = switch (this.unit.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> Math.sqrt(rt) * (double)WidgetUtils.getClientTickRate();
                case 2 -> Math.sqrt(rt) * 100.0;
            };
        } else {
            this.averagingWindow[this.windowPointer++] = 0.0;
        }
        if (this.windowPointer >= this.averagingWindow.length) {
            this.windowPointer = 0;
        }
        double avg = 0.0;
        for (double v : this.averagingWindow) {
            avg += v;
        }
        this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)(this.reduceDigits(avg /= (double)this.averagingWindow.length) + this.unit.displayName)));
    }

    private String reduceDigits(double v) {
        if (this.digitsAfterComma == 0) {
            return String.valueOf((int)Math.floor(v));
        }
        double f = Math.pow(10.0, this.digitsAfterComma);
        return String.valueOf(Math.floor(v * f) / f);
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.speed");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.speed.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.unit = (Unit)((Object)((EnumWidgetSetting)settings.optionById("unit")).getValue());
        this.withXVelocity = ((ToggleWidgetSetting)settings.optionById("with_x")).getValue();
        this.withYVelocity = ((ToggleWidgetSetting)settings.optionById("with_y")).getValue();
        this.withZVelocity = ((ToggleWidgetSetting)settings.optionById("with_z")).getValue();
        this.digitsAfterComma = ((IntSliderWidgetSetting)settings.optionById("digits")).getValue();
        this.windowPointer = 0;
        this.averagingWindow = new double[((IntSliderWidgetSetting)settings.optionById("window_size")).getValue()];
    }

    public static enum Unit {
        METERS_PER_SECOND("m/s"),
        BLOCKS_PER_SECOND("b/s"),
        CENTIMETERS_PER_TICK("cm/t");

        public final String displayName;

        private Unit(String displayName) {
            this.displayName = displayName;
        }
    }
}

