/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.shiewk.widgets.WidgetSettingOption;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class EnumWidgetSetting<T extends Enum<T>>
extends WidgetSettingOption {
    private final Class<T> enumClass;
    private T value;
    private final Function<T, class_2561> enumNameGetter;
    private int height = 0;
    private boolean mouseClick = false;
    private boolean changed = false;
    private static final int COLOR_SELECTED = new Color(0, 95, 104, 255).getRGB();
    private static final int COLOR_UNSELECTED = new Color(0, 0, 0, 50).getRGB();
    private static final int COLOR_UNSELECTED_HOVER = new Color(80, 80, 80, 50).getRGB();
    private static final int COLOR_TEXT = new Color(255, 255, 255, 255).getRGB();

    public EnumWidgetSetting(String id, class_2561 name, Class<T> enumClass, T defaultValue, Function<T, class_2561> enumNameGetter) {
        super(id, name);
        this.enumClass = enumClass;
        this.value = defaultValue;
        this.enumNameGetter = enumNameGetter;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public JsonElement saveState() {
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public void loadState(JsonElement state) {
        if (state.isJsonPrimitive() && state.getAsJsonPrimitive().isString()) {
            String name = state.getAsString();
            for (Enum constant : (Enum[])this.enumClass.getEnumConstants()) {
                if (!constant.name().equals(name)) continue;
                this.value = constant;
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int y = 0;
        int nx = 5;
        int bx = this.method_46426() + this.method_25368();
        for (Enum constant : (Enum[])this.enumClass.getEnumConstants()) {
            class_2561 name = this.enumNameGetter.apply(constant);
            int textRendererWidth = textRenderer.method_27525((class_5348)name);
            if (nx != 5 && nx + textRendererWidth + 20 > this.method_25368()) {
                y += 24;
                nx = 5;
            }
            boolean hover = mouseX <= bx - nx && mouseX >= bx - nx - 10 - textRendererWidth && mouseY <= y + 19 + this.method_46427() && mouseY >= y + this.method_46427();
            context.method_25294(bx - 10 - textRendererWidth - nx, y + this.method_46427(), bx - nx, y + 19 + this.method_46427(), constant == this.value ? COLOR_SELECTED : (hover ? COLOR_UNSELECTED_HOVER : COLOR_UNSELECTED));
            context.method_51439(textRenderer, name, bx - nx - 5 - textRendererWidth, y + 5 + this.method_46427(), COLOR_TEXT, true);
            if (hover && this.mouseClick) {
                this.value = constant;
                this.changed = true;
            }
            nx += textRendererWidth + 20;
        }
        this.mouseClick = false;
        this.height = y + 34;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mouseClick = true;
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.mouseClick = false;
        boolean changed = this.changed;
        this.changed = false;
        return changed;
    }

    public int method_25368() {
        return 200;
    }

    public int method_25364() {
        return this.height;
    }
}

