/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.WidgetSettingOption;
import de.shiewk.widgets.WidgetsMod;
import de.shiewk.widgets.client.WidgetManager;
import de.shiewk.widgets.utils.WidgetUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class WidgetSettings {
    public double posX = 0.0;
    public double posY = 0.0;
    private boolean enabled = false;
    private final ObjectArrayList<WidgetSettingOption> customSettings;

    private WidgetSettings(JsonObject data, List<WidgetSettingOption> settings) {
        this.customSettings = new ObjectArrayList(settings);
        if (data != null) {
            JsonElement enabled = data.get("enabled");
            this.enabled = enabled.isJsonPrimitive() && enabled.getAsJsonPrimitive().isBoolean() && enabled.getAsBoolean();
            JsonElement x = data.get("x");
            this.posX = x.isJsonPrimitive() ? (x.getAsJsonPrimitive().isNumber() ? x.getAsDouble() : 0.0) : 0.0;
            JsonElement y = data.get("y");
            this.posY = y.isJsonPrimitive() ? (y.getAsJsonPrimitive().isNumber() ? y.getAsDouble() : 0.0) : 0.0;
            JsonElement s = data.get("settings");
            if (s != null && s.isJsonObject()) {
                JsonObject savedSettings = s.getAsJsonObject();
                for (WidgetSettingOption setting : this.customSettings) {
                    String settingId = setting.getId();
                    if (!savedSettings.has(settingId)) continue;
                    try {
                        setting.loadState(savedSettings.get(settingId));
                    }
                    catch (Throwable e) {
                        WidgetsMod.LOGGER.error("Could not load setting '{}' from element {}:", (Object)settingId, (Object)savedSettings.get(settingId));
                        WidgetsMod.LOGGER.error(e.toString());
                        for (StackTraceElement element : e.getStackTrace()) {
                            WidgetsMod.LOGGER.error(element.toString());
                        }
                    }
                }
            }
        }
    }

    public static WidgetSettings ofId(class_2960 id, List<WidgetSettingOption> customSettings) {
        JsonObject data = WidgetManager.loadWidget(id);
        return new WidgetSettings(data, customSettings);
    }

    public void setPosX(double v, int widgetWidth, int maxWidth) {
        this.posX = class_3532.method_15350((double)v, (double)0.0, (double)(100.0 - WidgetUtils.translateToWidgetSettingsValue(widgetWidth, maxWidth)));
    }

    public void setPosY(double v, int widgetHeight, int maxHeight) {
        this.posY = class_3532.method_15350((double)v, (double)0.0, (double)(100.0 - WidgetUtils.translateToWidgetSettingsValue(widgetHeight, maxHeight)));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(ModWidget widget, boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            WidgetManager.enable(widget);
        } else {
            WidgetManager.disable(widget);
        }
    }

    public void toggleEnabled(ModWidget widget) {
        this.setEnabled(widget, !this.enabled);
    }

    public final JsonObject saveState() {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)this.posX);
        object.addProperty("y", (Number)this.posY);
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        JsonObject customSettings = new JsonObject();
        for (WidgetSettingOption customSetting : this.customSettings) {
            customSettings.add(customSetting.getId(), customSetting.saveState());
        }
        object.add("settings", (JsonElement)customSettings);
        return object;
    }

    public WidgetSettingOption optionById(String id) {
        for (WidgetSettingOption customSetting : this.customSettings) {
            if (!customSetting.getId().equals(id)) continue;
            return customSetting;
        }
        return null;
    }

    public ObjectArrayList<WidgetSettingOption> getCustomSettings() {
        return this.customSettings.clone();
    }
}

