/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.client.screen;

import de.shiewk.widgets.Dimensionable;
import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.client.WidgetManager;
import de.shiewk.widgets.client.screen.AnimatedScreen;
import de.shiewk.widgets.utils.WidgetUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class EditWidgetPositionsScreen
extends AnimatedScreen {
    private final class_437 parent;
    private final Consumer<ModWidget> onEdit;
    private boolean alignX = true;
    private boolean alignY = true;
    private static final int SELECT_COLOR = Color.GREEN.getRGB();
    private static final int ALIGN_COLOR = Color.ORANGE.getRGB();
    private static final int ALIGN_DISABLED_COLOR = Color.GRAY.getRGB();
    private ModWidget selectedWidget = null;
    private ModWidget hoveredWidget = null;

    public EditWidgetPositionsScreen(class_437 parent, Consumer<ModWidget> onEdit) {
        super((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions"), parent, 500);
        this.parent = parent;
        this.onEdit = onEdit;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    @Nullable
    private AlignResult alignX(double x, int width, ModWidget widget) {
        double endX = x + (double)width;
        int factor = this.alignX ? 2 : 0;
        for (Dimensionable dimensionable : this.getAlignments(widget)) {
            if (dimensionable == widget) continue;
            int rectWidth = dimensionable.width();
            double nwx = Math.min(dimensionable.getX(this.field_22789), (double)(this.field_22789 - rectWidth));
            double nww = (float)rectWidth * dimensionable.getScaleFactor();
            if (endX < nwx + (double)factor && endX > nwx - (double)factor) {
                return new AlignResult(nwx - (double)width, true);
            }
            if (x < nwx + (double)factor && x > nwx - (double)factor) {
                return new AlignResult(nwx, false);
            }
            if (endX < nwx + nww + (double)factor && endX > nwx + nww - (double)factor) {
                return new AlignResult(nwx + nww - (double)width, true);
            }
            if (!(x < nwx + nww + (double)factor) || !(x > nwx + nww - (double)factor)) continue;
            return new AlignResult(nwx + nww, false);
        }
        return null;
    }

    private Iterable<? extends Dimensionable> getAlignments(Dimensionable rel) {
        ObjectArrayList alignments = new ObjectArrayList();
        for (ModWidget widget : WidgetManager.getEnabledWidgets()) {
            alignments.add((Object)widget);
        }
        alignments.add((Object)new Alignment(2, 2, this.field_22789 / 2 - 2, this.field_22790 / 2 - 2));
        alignments.add((Object)new Alignment(this.field_22789 / 2, this.field_22790 / 2, this.field_22789 / 2 - 2, this.field_22790 / 2 - 2));
        alignments.add((Object)new Alignment(2, this.field_22790 / 2, this.field_22789 / 2 - 2, this.field_22790 / 2 - 2));
        alignments.add((Object)new Alignment(this.field_22789 / 2, 2, this.field_22789 / 2 - 2, this.field_22790 / 2 - 2));
        alignments.add((Object)new Alignment((int)((float)this.field_22789 / 2.0f - (float)rel.width() * rel.getScaleFactor() / 2.0f), (int)((float)this.field_22790 / 2.0f - (float)rel.height() * rel.getScaleFactor() / 2.0f), (int)((float)rel.width() * rel.getScaleFactor()), (int)((float)rel.height() * rel.getScaleFactor())));
        return alignments;
    }

    @Nullable
    private AlignResult alignY(double y, int height, ModWidget widget) {
        double endY = y + (double)height;
        int factor = this.alignY ? 2 : 0;
        for (Dimensionable dimensionable : this.getAlignments(widget)) {
            if (dimensionable == widget) continue;
            int rectHeight = dimensionable.height();
            double nwy = Math.min(dimensionable.getY(this.field_22790), (double)(this.field_22790 - rectHeight));
            double nwh = (float)rectHeight * dimensionable.getScaleFactor();
            if (endY < nwy + (double)factor && endY > nwy - (double)factor) {
                return new AlignResult(nwy - (double)height, true);
            }
            if (y < nwy + (double)factor && y > nwy - (double)factor) {
                return new AlignResult(nwy, false);
            }
            if (endY < nwy + nwh + (double)factor && endY > nwy + nwh - (double)factor) {
                return new AlignResult(nwy + nwh - (double)height, true);
            }
            if (!(y < nwy + nwh + (double)factor) || !(y > nwy + nwh - (double)factor)) continue;
            return new AlignResult(nwy + nwh, false);
        }
        return null;
    }

    @Override
    public void renderScreenContents(class_332 context, int mouseX, int mouseY, float delta) {
        assert (this.field_22787 != null);
        for (ModWidget widget : WidgetManager.getEnabledWidgets()) {
            WidgetSettings settings = widget.getSettings();
            int ww = (int)((float)widget.width() * widget.getScaleFactor());
            double wx = Math.min(WidgetUtils.translateToScreen(settings.posX, this.field_22789), (double)(this.field_22789 - ww));
            int wh = (int)((float)widget.height() * widget.getScaleFactor());
            double wy = Math.min(WidgetUtils.translateToScreen(settings.posY, this.field_22790), (double)(this.field_22790 - wh));
            if (this.selectedWidget == widget) {
                AlignResult alignedY;
                AlignResult alignedX = this.alignX(wx, ww, widget);
                if (alignedX != null) {
                    context.method_51742((int)(!alignedX.isEnd() ? alignedX.result() : alignedX.result() + (double)ww), 0, this.field_22790, this.alignX ? ALIGN_COLOR : ALIGN_DISABLED_COLOR);
                    wx = alignedX.result();
                }
                if ((alignedY = this.alignY(wy, wh, widget)) != null) {
                    context.method_51738(0, this.field_22789, (int)(!alignedY.isEnd() ? alignedY.result() : alignedY.result() + (double)wh), this.alignY ? ALIGN_COLOR : ALIGN_DISABLED_COLOR);
                    wy = alignedY.result();
                }
            }
            if (this.hoveredWidget == null || this.hoveredWidget == widget) {
                if ((double)mouseX <= wx + (double)ww && (double)mouseX >= wx && (double)mouseY <= wy + (double)wh && (double)mouseY >= wy) {
                    if (this.hoveredWidget == null) {
                        this.hoveredWidget = widget;
                    }
                } else {
                    this.hoveredWidget = null;
                }
            }
            if (this.selectedWidget == null ? this.hoveredWidget == widget : this.selectedWidget == widget) {
                context.method_73198((int)Math.round(wx - 1.0), (int)Math.round(wy - 1.0), ww + 2, wh + 2, SELECT_COLOR);
                context.method_73198((int)Math.round(wx), (int)Math.round(wy), ww, wh, SELECT_COLOR);
            }
            widget.render(context, class_156.method_648(), this.field_22793, (int)Math.round(wx), (int)Math.round(wy));
        }
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.selectedWidget != null) {
            AlignResult alignedY;
            AlignResult alignedX = this.alignX(WidgetUtils.translateToScreen(this.selectedWidget.getSettings().posX, this.field_22789), (int)((float)this.selectedWidget.width() * this.selectedWidget.getScaleFactor()), this.selectedWidget);
            if (alignedX != null) {
                this.selectedWidget.getSettings().setPosX(WidgetUtils.translateToWidgetSettingsValue(alignedX.result(), this.field_22789), (int)((float)this.selectedWidget.width() * this.selectedWidget.getScaleFactor()), this.field_22789);
            }
            if ((alignedY = this.alignY(WidgetUtils.translateToScreen(this.selectedWidget.getSettings().posY, this.field_22790), (int)((float)this.selectedWidget.height() * this.selectedWidget.getScaleFactor()), this.selectedWidget)) != null) {
                this.selectedWidget.getSettings().setPosY(WidgetUtils.translateToWidgetSettingsValue(alignedY.result(), this.field_22790), (int)((float)this.selectedWidget.height() * this.selectedWidget.getScaleFactor()), this.field_22790);
            }
            this.onEdit.accept(this.selectedWidget);
            this.selectedWidget = null;
        }
        return super.method_25406(click);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0 && this.hoveredWidget != null) {
            this.selectedWidget = this.hoveredWidget;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (click.method_74245() == 0) {
            assert (this.field_22787 != null);
            ModWidget widget = this.selectedWidget;
            if (widget != null) {
                WidgetSettings settings = widget.getSettings();
                int ww = (int)((float)widget.width() * widget.getScaleFactor());
                int wx = (int)Math.min(WidgetUtils.translateToScreen(settings.posX, this.field_22789), (double)(this.field_22789 - ww));
                int wh = (int)((float)widget.height() * widget.getScaleFactor());
                int wy = (int)Math.min(WidgetUtils.translateToScreen(settings.posY, this.field_22790), (double)(this.field_22790 - wh));
                if (click.comp_4798() <= (double)(wx + ww) + deltaX && click.comp_4798() >= (double)wx + deltaX && click.comp_4799() <= (double)(wy + wh) + deltaY && click.comp_4799() >= (double)wy + deltaY) {
                    double newPosX = settings.posX + WidgetUtils.translateToWidgetSettingsValue(deltaX, this.field_22789);
                    double newPosY = settings.posY + WidgetUtils.translateToWidgetSettingsValue(deltaY, this.field_22790);
                    settings.setPosX(newPosX, ww, this.field_22789);
                    settings.setPosY(newPosY, wh, this.field_22790);
                    return true;
                }
            }
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43469((String)"widgets.ui.editPositions.snap", (Object[])new Object[]{this.alignX ? class_2561.method_43471((String)"gui.yes") : class_2561.method_43471((String)"gui.no")}), button -> {
            this.alignX = !this.alignX;
            this.alignY = !this.alignY;
            button.method_25355((class_2561)class_2561.method_43469((String)"widgets.ui.editPositions.snap", (Object[])new Object[]{this.alignX ? class_2561.method_43471((String)"gui.yes") : class_2561.method_43471((String)"gui.no")}));
        }).method_46433(this.field_22789 / 2 - 75, this.field_22790 / 2 - 10).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.snap.help"))).method_46431());
    }

    private record AlignResult(double result, boolean isEnd) {
    }

    private record Alignment(int x, int y, int width, int height) implements Dimensionable
    {
        @Override
        public double getX(int mx) {
            return this.x;
        }

        @Override
        public double getY(int my) {
            return this.y;
        }

        @Override
        public float getScaleFactor() {
            return 1.0f;
        }
    }
}

