/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.client.screen;

import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.client.WidgetManager;
import de.shiewk.widgets.client.screen.EditWidgetPositionsScreen;
import de.shiewk.widgets.client.screen.components.WidgetListWidget;
import de.shiewk.widgets.utils.WidgetUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7849;
import net.minecraft.class_8021;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class WidgetConfigScreen
extends class_437 {
    private final class_437 parent;
    private final long creationTime = class_156.method_648();
    private String search = "";
    private WidgetListWidget widgetList = null;
    private final ArrayList<ModWidget> widgetsEdited = new ArrayList();
    private final Consumer<ModWidget> onWidgetEdit = this::changedSettings;

    private double getScreenTimeMs() {
        return (double)(class_156.method_648() - this.creationTime) / 1000000.0;
    }

    public WidgetConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"widgets.ui.config"));
        this.parent = parent;
    }

    public void method_25419() {
        WidgetManager.saveWidgets(this.widgetsEdited);
        for (ModWidget widget : this.widgetsEdited) {
            widget.onSettingsChanged(widget.getSettings());
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        super.method_25426();
        class_7849 agw = new class_7849(3, this.field_22790 - 22, this.field_22789 - 6, 20, class_7849.class_7851.field_40789);
        class_342 searchField = new class_342(this.field_22793, this.field_22789 - 160, 20, (class_2561)class_2561.method_43473());
        searchField.method_47404((class_2561)class_2561.method_43471((String)"widgets.ui.search"));
        searchField.method_1863(this::search);
        if (this.widgetList != null) {
            searchField.method_1852(this.getSearchQuery());
        }
        agw.method_46495((class_8021)searchField);
        agw.method_46495((class_8021)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions"), this::switchToEditPositions).method_46431());
        agw.method_48222();
        agw.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        if (Objects.equals(this.search, "")) {
            this.search("");
        }
    }

    private String getSearchQuery() {
        return this.search;
    }

    public void setSearchQuery(String search) {
        this.search = search;
    }

    private void search(String query) {
        this.setSearchQuery(query);
        this.widgetList = new WidgetListWidget(0, 0, this.field_22789 - 4, this.field_22790 - 24, (class_2561)class_2561.method_43471((String)"widgets.ui.config"), this.field_22787, WidgetManager.getAllWidgets().stream().filter(this::searchQueryMatches).toList(), this.field_22793, this.onWidgetEdit);
    }

    private void switchToEditPositions(class_4185 widget) {
        widget.field_22763 = false;
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new EditWidgetPositionsScreen(this, this.onWidgetEdit));
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled)) {
            return true;
        }
        return this.widgetList.method_25402(click, doubled);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return this.widgetList.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        assert (this.field_22787 != null);
        double time = this.getScreenTimeMs();
        if (time < 400.0) {
            Matrix3x2fStack stack = context.method_51448().pushMatrix();
            float v = (float)WidgetUtils.computeEasing(time / 400.0);
            stack.translate((float)((double)this.field_22789 / 2.0 - (double)((float)this.field_22789 * v) / 2.0), (float)((double)this.field_22790 / 2.0 - (double)((float)this.field_22790 * v) / 2.0), (Matrix3x2f)stack);
            stack.scale(v, v, (Matrix3x2f)stack);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.widgetList != null) {
            this.widgetList.method_25394(context, mouseX, mouseY, delta);
        }
        if (time < 400.0) {
            context.method_51448().popMatrix();
        }
    }

    private boolean searchQueryMatches(ModWidget widget) {
        return widget.getName().getString().contains(this.search) || widget.getDescription().getString().contains(this.search) || widget.getId().toString().contains(this.search);
    }

    public void changedSettings(ModWidget widget) {
        if (!this.widgetsEdited.contains(widget)) {
            this.widgetsEdited.add(widget);
        }
    }
}

