/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CPSWidget
extends BasicTextWidget {
    private static boolean countLeftClicks = true;
    private static boolean countMiddleClicks = true;
    private static boolean countRightClicks = true;
    private static final ObjectArrayList<Click> leftClicks = new ObjectArrayList();
    private static final ObjectArrayList<Click> middleClicks = new ObjectArrayList();
    private static final ObjectArrayList<Click> rightClicks = new ObjectArrayList();
    private Appearance appearance = Appearance.UNIFIED;

    public static int getCPSLeft() {
        return leftClicks.size();
    }

    public static int getCPSMiddle() {
        return middleClicks.size();
    }

    public static int getCPSRight() {
        return rightClicks.size();
    }

    public CPSWidget(class_2960 id) {
        super(id, List.of(new EnumWidgetSetting<Appearance>("appearance", (class_2561)class_2561.method_43471((String)"widgets.widgets.cps.appearance"), Appearance.class, Appearance.UNIFIED, appearance -> class_2561.method_43471((String)("widgets.widgets.cps.appearance." + appearance.key))), new ToggleWidgetSetting("left", (class_2561)class_2561.method_43471((String)"widgets.widgets.cps.left"), true), new ToggleWidgetSetting("middle", (class_2561)class_2561.method_43471((String)"widgets.widgets.cps.middle"), false), new ToggleWidgetSetting("right", (class_2561)class_2561.method_43471((String)"widgets.widgets.cps.right"), true)));
    }

    public static void clickLeft() {
        if (countLeftClicks) {
            leftClicks.add((Object)new Click());
        }
    }

    public static void clickMiddle() {
        if (countMiddleClicks) {
            middleClicks.add((Object)new Click());
        }
    }

    public static void clickRight() {
        if (countRightClicks) {
            rightClicks.add((Object)new Click());
        }
    }

    @Override
    public void tickWidget() {
        int left = 0;
        int right = 0;
        int middle = 0;
        long mtime = class_156.method_658();
        if (countLeftClicks) {
            leftClicks.removeIf(click -> click.expiresAt <= mtime);
            left = leftClicks.size();
        }
        if (countRightClicks) {
            rightClicks.removeIf(click -> click.expiresAt <= mtime);
            right = rightClicks.size();
        }
        if (countMiddleClicks) {
            middleClicks.removeIf(click -> click.expiresAt <= mtime);
            middle = middleClicks.size();
        }
        this.formatAndSetRenderText((class_2561)(switch (this.appearance.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> class_2561.method_43470((String)(left + right + middle + " CPS"));
            case 0, 1 -> class_2561.method_43470((String)(String.valueOf(this.getClickText(left, middle, right)) + " CPS"));
        }));
    }

    @NotNull
    private StringBuilder getClickText(int left, int middle, int right) {
        StringBuilder sb = new StringBuilder();
        if (countLeftClicks) {
            sb.append(left);
        }
        if (countMiddleClicks) {
            if (!sb.isEmpty()) {
                sb.append(this.appearance == Appearance.SPLIT_PIPE ? " | " : "/");
            }
            sb.append(middle);
        }
        if (countRightClicks) {
            if (!sb.isEmpty()) {
                sb.append(this.appearance == Appearance.SPLIT_PIPE ? " | " : "/");
            }
            sb.append(right);
        }
        return sb;
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        countLeftClicks = ((ToggleWidgetSetting)settings.optionById("left")).getValue();
        countMiddleClicks = ((ToggleWidgetSetting)settings.optionById("middle")).getValue();
        countRightClicks = ((ToggleWidgetSetting)settings.optionById("right")).getValue();
        this.appearance = (Appearance)((Object)((EnumWidgetSetting)settings.optionById("appearance")).getValue());
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.cps");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.cps.description");
    }

    public static enum Appearance {
        SPLIT_PIPE("pipe"),
        SPLIT_SLASH("slash"),
        UNIFIED("unified");

        public final String key;

        private Appearance(String key) {
            this.key = key;
        }
    }

    public static class Click {
        public int ticks = 0;
        public final long expiresAt = class_156.method_658() + 1000L;

        @Deprecated(forRemoval=true, since="1.2.1")
        public int tick() {
            return this.ticks++;
        }
    }
}

