/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class ComboWidget
extends BasicTextWidget
implements AttackEntityCallback {
    private static ComboWidget INSTANCE;
    private boolean showLabel = true;
    private int targetEntityId = 0;
    private boolean hitPlanned = false;
    private int combo = 0;
    private int ticksSinceUpdate = 0;
    private int displayThreshold = 0;

    public ComboWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("show_label", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.showLabel"), true), new IntSliderWidgetSetting("display_threshold", (class_2561)class_2561.method_43471((String)"widgets.widgets.combo.displayThreshold"), 0, 0, 5)));
        if (INSTANCE != null) {
            throw new IllegalStateException("Instance already initialized");
        }
        INSTANCE = this;
    }

    public class_1269 interact(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        this.clientHitEntity(entity.method_5628());
        return class_1269.field_5811;
    }

    private void clientHitEntity(int targetEntityId) {
        int oldTarget = this.targetEntityId;
        if (oldTarget != targetEntityId) {
            this.resetCombo();
        }
        this.targetEntityId = targetEntityId;
        this.hitPlanned = true;
    }

    public static void entityTakeDamage(int clientEntityId, int damagedEntityId) {
        INSTANCE.entityTakeDamage0(clientEntityId, damagedEntityId);
    }

    private void entityTakeDamage0(int clientEntityId, int damagedEntityId) {
        if (damagedEntityId == clientEntityId) {
            this.resetCombo();
        } else if (damagedEntityId == this.targetEntityId && this.hitPlanned) {
            this.hitPlanned = false;
            ++this.combo;
            this.ticksSinceUpdate = 0;
            this.updateComboText();
        }
    }

    @Override
    public void tickWidget() {
        if (this.ticksSinceUpdate > 40) {
            this.resetCombo();
            this.hitPlanned = false;
        }
        ++this.ticksSinceUpdate;
    }

    private void resetCombo() {
        this.combo = 0;
        this.ticksSinceUpdate = 0;
        this.updateComboText();
    }

    private void updateComboText() {
        boolean bl = this.shouldRender = this.combo >= this.displayThreshold;
        if (this.showLabel) {
            this.formatAndSetRenderText((class_2561)class_2561.method_43469((String)"widgets.widgets.combo.combo", (Object[])new Object[]{this.combo}));
        } else {
            this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)("" + this.combo)));
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.combo");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.combo.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.displayThreshold = ((IntSliderWidgetSetting)settings.optionById("display_threshold")).getValue();
        this.showLabel = ((ToggleWidgetSetting)settings.optionById("show_label")).getValue();
        this.updateComboText();
    }
}

