/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.ResizableWidget;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.RGBAColorWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class CoordinatesWidget
extends ResizableWidget {
    private String textX = "X";
    private String textY = "Y";
    private String textZ = "Z";
    private int txc = 0;
    private int tyc = 0;
    private int tzc = 0;
    private int rainbowSpeed = 3;
    private boolean shadow = true;
    private boolean rainbow = false;
    protected static final int WIDTH = 80;
    protected static final int PADDING = 6;
    protected static final int DEFAULT_BACKGROUND_COLOR = new Color(0, 0, 0, 80).getRGB();
    protected static final int DEFAULT_TEXT_COLOR = new Color(255, 255, 255, 255).getRGB();
    protected int backgroundColor = DEFAULT_BACKGROUND_COLOR;
    protected int textColor = DEFAULT_TEXT_COLOR;
    protected int paddingX = 6;
    protected int paddingY = 6;
    protected int width = 80;
    protected boolean showX = true;
    protected boolean showY = true;
    protected boolean showZ = true;

    public CoordinatesWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("x", (class_2561)class_2561.method_43471((String)"widgets.widgets.coordinates.showX"), true), new ToggleWidgetSetting("y", (class_2561)class_2561.method_43471((String)"widgets.widgets.coordinates.showY"), true), new ToggleWidgetSetting("z", (class_2561)class_2561.method_43471((String)"widgets.widgets.coordinates.showZ"), true), new RGBAColorWidgetSetting("backgroundcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.background"), 0, 0, 0, 80), new ToggleWidgetSetting("rainbow", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow"), false), new RGBAColorWidgetSetting("textcolor", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textcolor"), 255, 255, 255, 255), new IntSliderWidgetSetting("rainbow_speed", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow.speed"), 1, 3, 10), new IntSliderWidgetSetting("width", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.width"), 10, 80, 240), new IntSliderWidgetSetting("paddingX", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.paddingX"), 0, 5, 20), new IntSliderWidgetSetting("paddingY", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.paddingY"), 0, 5, 20), new ToggleWidgetSetting("shadow", (class_2561)class_2561.method_43471((String)"widgets.widgets.basictext.textshadow"), true)));
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.rainbow);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> this.rainbow);
    }

    @Override
    public void renderScaled(class_332 context, long mt, class_327 textRenderer, int posX, int posY) {
        context.method_25294(posX, posY, posX + this.width(), posY + this.height(), this.backgroundColor);
        int y = this.paddingY;
        if (this.showX) {
            context.method_51433(textRenderer, "X: ", posX + this.paddingX, posY + ++y, this.textColor(mt), this.shadow);
            context.method_51433(textRenderer, this.textX, posX + this.txc, posY + y, this.textColor(mt), this.shadow);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
        if (this.showY) {
            context.method_51433(textRenderer, "Y: ", posX + this.paddingX, posY + ++y, this.textColor(mt), this.shadow);
            context.method_51433(textRenderer, this.textY, posX + this.tyc, posY + y, this.textColor(mt), this.shadow);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
        if (this.showZ) {
            context.method_51433(textRenderer, "Z: ", posX + this.paddingX, posY + ++y, this.textColor(mt), this.shadow);
            context.method_51433(textRenderer, this.textZ, posX + this.tzc, posY + y, this.textColor(mt), this.shadow);
        }
    }

    private int textColor(long n) {
        return this.rainbow ? BasicTextWidget.rainbowColor(n, this.rainbowSpeed) : this.textColor;
    }

    @Override
    public void tick() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.txc = this.width() - textRenderer.method_1727(this.textX) - this.paddingX;
        this.tyc = this.width() - textRenderer.method_1727(this.textY) - this.paddingX;
        this.tzc = this.width() - textRenderer.method_1727(this.textZ) - this.paddingX;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            this.textX = "?";
            this.textY = "?";
            this.textZ = "?";
        } else {
            this.textX = String.valueOf(player.method_31477());
            this.textY = String.valueOf(player.method_31478());
            this.textZ = String.valueOf(player.method_31479());
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.coordinates");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.coordinates.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.backgroundColor = ((RGBAColorWidgetSetting)settings.optionById("backgroundcolor")).getColor();
        this.textColor = ((RGBAColorWidgetSetting)settings.optionById("textcolor")).getColor();
        this.showX = ((ToggleWidgetSetting)settings.optionById("x")).getValue();
        this.showY = ((ToggleWidgetSetting)settings.optionById("y")).getValue();
        this.showZ = ((ToggleWidgetSetting)settings.optionById("z")).getValue();
        this.paddingX = ((IntSliderWidgetSetting)settings.optionById("paddingX")).getValue();
        this.paddingY = ((IntSliderWidgetSetting)settings.optionById("paddingY")).getValue();
        this.width = ((IntSliderWidgetSetting)settings.optionById("width")).getValue();
        this.shadow = ((ToggleWidgetSetting)settings.optionById("shadow")).getValue();
        this.rainbow = ((ToggleWidgetSetting)settings.optionById("rainbow")).getValue();
        this.rainbowSpeed = ((IntSliderWidgetSetting)settings.optionById("rainbow_speed")).getValue();
    }

    @Override
    public int width() {
        return this.width + this.paddingX * 2;
    }

    @Override
    public int height() {
        int height = 2 * this.paddingY;
        if (this.showX) {
            height += 11;
        }
        if (this.showY) {
            height += 11;
        }
        if (this.showZ) {
            height += 11;
        }
        return height;
    }
}

