/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.ResizableWidget;
import de.shiewk.widgets.widgets.settings.EnumWidgetSetting;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.RGBAColorWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class InventoryWidget
extends ResizableWidget {
    private static final class_2960 VANILLA_INVENTORY = class_2960.method_60655((String)"widgets", (String)"textures/vanilla_inventory.png");
    private static final class_2960 TEXTURE_PACK_INVENTORY = class_2960.method_60656((String)"textures/gui/container/inventory.png");
    private InventoryMode mode = InventoryMode.TEXTURE_PACK;
    private class_1661 inventory;
    private boolean rainbowGrid = false;
    private int gridColor = -16777216;
    private int gridRainbowSpeed = 3;
    private boolean rainbowBoxes = false;
    private int boxColor = -16777216;
    private int boxRainbowSpeed = 3;
    private boolean showHotbar = false;

    public InventoryWidget(class_2960 id) {
        super(id, List.of(new EnumWidgetSetting<InventoryMode>("mode", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.mode"), InventoryMode.class, InventoryMode.TEXTURE_PACK, InventoryMode::display), new ToggleWidgetSetting("show_hotbar", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.showHotbar"), true), new ToggleWidgetSetting("rainbow_grid", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.rainbowGrid"), false), new IntSliderWidgetSetting("grid_rainbow_speed", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow.speed"), 1, 3, 10), new RGBAColorWidgetSetting("grid_color", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.gridColor"), 0, 0, 0, 255), new ToggleWidgetSetting("rainbow_boxes", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.rainbowBoxes"), false), new IntSliderWidgetSetting("box_rainbow_speed", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.rainbow.speed"), 1, 3, 10), new RGBAColorWidgetSetting("box_color", (class_2561)class_2561.method_43471((String)"widgets.widgets.inventory.boxColor"), 80, 80, 80, 128)));
        this.getSettings().optionById("rainbow_grid").setShowCondition(() -> this.mode == InventoryMode.GRID);
        this.getSettings().optionById("grid_rainbow_speed").setShowCondition(() -> this.mode == InventoryMode.GRID && this.rainbowGrid);
        this.getSettings().optionById("grid_color").setShowCondition(() -> this.mode == InventoryMode.GRID && !this.rainbowGrid);
        this.getSettings().optionById("rainbow_boxes").setShowCondition(() -> this.mode == InventoryMode.BOXES);
        this.getSettings().optionById("box_rainbow_speed").setShowCondition(() -> this.mode == InventoryMode.BOXES && this.rainbowBoxes);
        this.getSettings().optionById("box_color").setShowCondition(() -> this.mode == InventoryMode.BOXES && !this.rainbowBoxes);
        this.getSettings().optionById("show_hotbar").setShowCondition(() -> this.mode.canDisableHotbar);
    }

    @Override
    public void renderScaled(class_332 context, long measuringTimeNano, class_327 textRenderer, int posX, int posY) {
        this.drawBackground(context, measuringTimeNano, posX, posY);
        if (this.inventory != null) {
            this.drawItems(context, textRenderer, switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> posX + 8;
                case 3 -> posX + 1;
                case 2, 4 -> posX;
            }, switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> posY + 9;
                case 3 -> posY + 1;
                case 2, 4 -> posY;
            });
        }
    }

    private void drawBackground(class_332 context, long mt, int posX, int posY) {
        switch (this.mode.ordinal()) {
            case 0: {
                context.method_25290(class_10799.field_56883, VANILLA_INVENTORY, posX, posY, 0.0f, 0.0f, 176, 91, 176, 91);
                break;
            }
            case 1: {
                context.method_44379(posX, posY, posX + this.width(), posY + 6);
                context.method_25290(class_10799.field_56883, TEXTURE_PACK_INVENTORY, posX, posY, 0.0f, 0.0f, 256, 256, 256, 256);
                context.method_44380();
                context.method_44379(posX, posY + 6, posX + this.width(), posY + this.height());
                context.method_25290(class_10799.field_56883, TEXTURE_PACK_INVENTORY, posX, posY - 75, 0.0f, 0.0f, 256, 256, 256, 256);
                context.method_44380();
                break;
            }
            case 3: {
                int gridColor = this.rainbowGrid ? BasicTextWidget.rainbowColor(mt, this.gridRainbowSpeed) : this.gridColor;
                context.method_51738(posX, posX + this.width(), posY, gridColor);
                context.method_51738(posX, posX + this.width(), posY + 18, gridColor);
                context.method_51738(posX, posX + this.width(), posY + 36, gridColor);
                context.method_51738(posX, posX + this.width(), posY + 54, gridColor);
                if (this.showHotbar) {
                    context.method_51738(posX, posX + this.width(), posY + 58, gridColor);
                    context.method_51738(posX, posX + this.width(), posY + 76, gridColor);
                }
                context.method_51742(posX, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 18, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 36, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 54, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 72, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 90, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 108, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 126, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 144, posY, posY + this.height(), gridColor);
                context.method_51742(posX + 162, posY, posY + this.height(), gridColor);
                break;
            }
            case 4: {
                int boxColor = this.rainbowBoxes ? BasicTextWidget.rainbowColor(mt, this.boxRainbowSpeed) & 0xFFFFFF | this.boxColor & 0xFF000000 : this.boxColor;
                for (int ry = 0; ry < 4; ++ry) {
                    if (ry == 0 && !this.showHotbar) continue;
                    for (int rx = 0; rx < 9; ++rx) {
                        int itemY = ry == 0 ? posY + 58 : posY + (ry - 1) * 18;
                        int itemX = posX + rx * 18;
                        context.method_25294(itemX, itemY, itemX + 16, itemY + 16, boxColor);
                    }
                }
                break;
            }
        }
    }

    private void drawItems(class_332 context, class_327 textRenderer, int posX, int posY) {
        for (int ry = 0; ry < 4; ++ry) {
            if (ry == 0 && !this.showHotbar) continue;
            for (int rx = 0; rx < 9; ++rx) {
                int slot = ry * 9 + rx;
                class_1799 stack = this.inventory.method_5438(slot);
                if (stack.method_7960()) continue;
                int itemY = ry == 0 ? posY + 58 : posY + (ry - 1) * 18;
                int itemX = posX + rx * 18;
                context.method_51427(stack, itemX, itemY);
                context.method_51431(textRenderer, stack, itemX, itemY);
            }
        }
    }

    @Override
    public void tick() {
        class_1661 clientPlayerEntityInventory;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (clientPlayerEntityInventory = player.method_31548()) != null) {
            this.inventory = clientPlayerEntityInventory;
        }
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.inventory");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.inventory.description");
    }

    @Override
    public int width() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> 176;
            case 2, 4 -> 160;
            case 3 -> 162;
        };
    }

    @Override
    public int height() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> 91;
            case 2, 4 -> {
                if (this.showHotbar) {
                    yield 74;
                }
                yield 53;
            }
            case 3 -> this.showHotbar ? 76 : 55;
        };
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.mode = (InventoryMode)((Object)((EnumWidgetSetting)settings.optionById("mode")).getValue());
        this.rainbowGrid = ((ToggleWidgetSetting)settings.optionById("rainbow_grid")).getValue();
        this.gridRainbowSpeed = ((IntSliderWidgetSetting)settings.optionById("grid_rainbow_speed")).getValue();
        this.gridColor = ((RGBAColorWidgetSetting)settings.optionById("grid_color")).getColor();
        this.rainbowBoxes = ((ToggleWidgetSetting)settings.optionById("rainbow_boxes")).getValue();
        this.boxRainbowSpeed = ((IntSliderWidgetSetting)settings.optionById("box_rainbow_speed")).getValue();
        this.boxColor = ((RGBAColorWidgetSetting)settings.optionById("box_color")).getColor();
        this.showHotbar = ((ToggleWidgetSetting)settings.optionById("show_hotbar")).getValue() || !this.mode.canDisableHotbar;
    }

    public static enum InventoryMode {
        VANILLA,
        TEXTURE_PACK,
        TRANSPARENT(true),
        GRID(true),
        BOXES(true);

        public final boolean canDisableHotbar;

        private InventoryMode() {
            this(false);
        }

        private InventoryMode(boolean canDisableHotbar) {
            this.canDisableHotbar = canDisableHotbar;
        }

        public class_2561 display() {
            return class_2561.method_43471((String)("widgets.widgets.inventory.mode." + this.name().toLowerCase()));
        }
    }
}

