/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class MemoryUsageWidget
extends BasicTextWidget {
    private boolean showPercentage = true;
    private boolean showLabel = true;

    public MemoryUsageWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("percentage", (class_2561)class_2561.method_43471((String)"widgets.widgets.memory.showPercentage"), true), new ToggleWidgetSetting("label", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.showLabel"), true)));
    }

    @Override
    public void tickWidget() {
        String memUsageString;
        Runtime runtime = Runtime.getRuntime();
        long memTotal = runtime.maxMemory();
        long memAllocated = runtime.totalMemory();
        long memFree = runtime.freeMemory();
        long memUsed = memAllocated - memFree;
        short memUsagePercent = (short)((float)memUsed / (float)memTotal * 100.0f);
        String string = memUsageString = this.showPercentage ? this.mib(memUsed) + "MiB / " + this.mib(memTotal) + "MiB (" + memUsagePercent + "%)" : this.mib(memUsed) + "MiB / " + this.mib(memTotal) + "MiB";
        if (this.showLabel) {
            this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)class_2561.method_43469((String)"widgets.widgets.memory.withLabel", (Object[])new Object[]{memUsageString}).getString()));
        } else {
            this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)memUsageString));
        }
    }

    private long mib(long bytes) {
        return bytes / 0x100000L;
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.memory");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.memory.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.showPercentage = ((ToggleWidgetSetting)settings.optionById("percentage")).getValue();
        this.showLabel = ((ToggleWidgetSetting)settings.optionById("label")).getValue();
    }
}

