/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets;

import org.joml.Vector2i;

public enum Anchor {
    TOP_LEFT,
    TOP_CENTER,
    TOP_RIGHT,
    CENTER_LEFT,
    CENTER,
    CENTER_RIGHT,
    BOTTOM_LEFT,
    BOTTOM_CENTER,
    BOTTOM_RIGHT;


    public int getAlignStartPosX(int scaledScreenWidth) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3, 6 -> 0;
            case 1, 4, 7 -> scaledScreenWidth / 2;
            case 2, 5, 8 -> scaledScreenWidth;
        };
    }

    public int getAlignStartPosY(int scaledScreenHeight) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> 0;
            case 3, 4, 5 -> scaledScreenHeight / 2;
            case 6, 7, 8 -> scaledScreenHeight;
        };
    }

    public Vector2i getTopLeft(int scaledScreenWidth, int scaledScreenHeight) {
        return new Vector2i(switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3, 6 -> 0;
            case 1, 4, 7 -> scaledScreenWidth / 3;
            case 2, 5, 8 -> (int)((double)scaledScreenWidth / 3.0 * 2.0);
        }, switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> 0;
            case 3, 4, 5 -> scaledScreenHeight / 3;
            case 6, 7, 8 -> (int)((double)scaledScreenHeight / 3.0 * 2.0);
        });
    }

    public static Anchor getAnchor(int scaledScreenWidth, int scaledScreenHeight, int posX, int posY) {
        for (Anchor anchor : Anchor.values()) {
            Vector2i topLeft = anchor.getTopLeft(scaledScreenWidth, scaledScreenHeight);
            if (topLeft.x > posX || topLeft.x + scaledScreenWidth / 3 < posX || topLeft.y > posY || topLeft.y + scaledScreenHeight / 3 < posY) continue;
            return anchor;
        }
        return null;
    }
}

