/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets;

import de.shiewk.widgets.Anchor;
import de.shiewk.widgets.WidgetSettingOption;
import de.shiewk.widgets.WidgetSettings;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public abstract class ModWidget {
    private final class_2960 id;
    private final WidgetSettings settings;

    protected ModWidget(class_2960 id, List<WidgetSettingOption> customSettings) {
        Objects.requireNonNull(id, "id");
        this.id = id;
        this.settings = WidgetSettings.ofId(id, customSettings);
    }

    public float getScaleFactor() {
        return 1.0f;
    }

    public final class_2960 getId() {
        return this.id;
    }

    public final WidgetSettings getSettings() {
        return this.settings;
    }

    public abstract void render(class_332 var1, long var2, class_327 var4, int var5, int var6);

    public abstract void tick();

    public abstract class_2561 getName();

    public abstract class_2561 getDescription();

    public abstract void onSettingsChanged(WidgetSettings var1);

    public int getX(int scaledScreenWidth) {
        return this.settings.anchor.getAlignStartPosX(scaledScreenWidth) + this.settings.offsetX;
    }

    public int getY(int scaledScreenHeight) {
        return this.settings.anchor.getAlignStartPosY(scaledScreenHeight) + this.settings.offsetY;
    }

    public abstract int width();

    public abstract int height();

    public float scaledWidth() {
        return (float)this.width() * this.getScaleFactor();
    }

    public float scaledHeight() {
        return (float)this.height() * this.getScaleFactor();
    }

    public void move(int dx, int dy) {
        this.settings.offsetX += dx;
        this.settings.offsetY += dy;
    }

    public void setPos(Anchor anchor, int offsetX, int offsetY) {
        this.getSettings().setPos(anchor, offsetX, offsetY);
    }

    public void setAbsolutePos(int x, int y, int scaledWindowWidth, int scaledWindowHeight) {
        Anchor anchor = Anchor.getAnchor(scaledWindowWidth, scaledWindowHeight, x, y);
        if (anchor == null) {
            throw new IllegalArgumentException("Provided coordinates have no corresponding anchor");
        }
        this.settings.setPos(anchor, x - anchor.getAlignStartPosX(scaledWindowWidth), y - anchor.getAlignStartPosY(scaledWindowHeight));
    }
}

