/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.shiewk.widgets.Anchor;
import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.WidgetSettingOption;
import de.shiewk.widgets.WidgetsMod;
import de.shiewk.widgets.client.WidgetManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;

public class WidgetSettings {
    public Anchor anchor = Anchor.TOP_LEFT;
    public int offsetX = 0;
    public int offsetY = 0;
    private boolean enabled = false;
    private final ObjectArrayList<WidgetSettingOption> customSettings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WidgetSettings(JsonObject data, List<WidgetSettingOption> settings) {
        this.customSettings = new ObjectArrayList(settings);
        if (data != null) {
            try {
                this.enabled = Objects.requireNonNullElse((Boolean)WidgetManager.gson.fromJson(data.get("enabled"), Boolean.class), false);
                this.anchor = (Anchor)((Object)WidgetManager.gson.fromJson(data.get("anchor"), Anchor.class));
                this.offsetX = Objects.requireNonNullElse((Integer)WidgetManager.gson.fromJson(data.get("ox"), Integer.class), 0);
                this.offsetY = Objects.requireNonNullElse((Integer)WidgetManager.gson.fromJson(data.get("oy"), Integer.class), 0);
            }
            catch (JsonSyntaxException | NullPointerException e) {
                WidgetsMod.LOGGER.info("Failed to load widget positioning:", e);
            }
            finally {
                if (this.anchor == null) {
                    this.anchor = Anchor.TOP_LEFT;
                }
            }
            JsonElement s = data.get("settings");
            if (s != null && s.isJsonObject()) {
                JsonObject savedSettings = s.getAsJsonObject();
                for (WidgetSettingOption setting : this.customSettings) {
                    String settingId = setting.getId();
                    if (!savedSettings.has(settingId)) continue;
                    try {
                        setting.loadState(savedSettings.get(settingId));
                    }
                    catch (Throwable e) {
                        WidgetsMod.LOGGER.error("Could not load setting '{}' from element {}:", (Object)settingId, (Object)savedSettings.get(settingId));
                        WidgetsMod.LOGGER.error(e.toString());
                        for (StackTraceElement element : e.getStackTrace()) {
                            WidgetsMod.LOGGER.error(element.toString());
                        }
                    }
                }
            }
        }
    }

    public static WidgetSettings ofId(class_2960 id, List<WidgetSettingOption> customSettings) {
        JsonObject data = WidgetManager.loadWidget(id);
        return new WidgetSettings(data, customSettings);
    }

    public void setPos(Anchor anchor, int offsetX, int offsetY) {
        this.anchor = anchor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(ModWidget widget, boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            WidgetManager.enable(widget);
        } else {
            WidgetManager.disable(widget);
        }
    }

    public void toggleEnabled(ModWidget widget) {
        this.setEnabled(widget, !this.enabled);
    }

    public final JsonObject saveState() {
        JsonObject object = new JsonObject();
        object.add("anchor", WidgetManager.gson.toJsonTree((Object)this.anchor));
        object.add("enabled", WidgetManager.gson.toJsonTree((Object)this.enabled));
        object.add("ox", WidgetManager.gson.toJsonTree((Object)this.offsetX));
        object.add("oy", WidgetManager.gson.toJsonTree((Object)this.offsetY));
        JsonObject customSettings = new JsonObject();
        for (WidgetSettingOption customSetting : this.customSettings) {
            customSettings.add(customSetting.getId(), customSetting.saveState());
        }
        object.add("settings", (JsonElement)customSettings);
        return object;
    }

    public WidgetSettingOption optionById(String id) {
        for (WidgetSettingOption customSetting : this.customSettings) {
            if (!customSetting.getId().equals(id)) continue;
            return customSetting;
        }
        return null;
    }

    public ObjectArrayList<WidgetSettingOption> getCustomSettings() {
        return this.customSettings.clone();
    }
}

