/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.client.screen;

import de.shiewk.widgets.Anchor;
import de.shiewk.widgets.ModWidget;
import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.client.WidgetManager;
import de.shiewk.widgets.client.screen.AnimatedScreen;
import de.shiewk.widgets.client.screen.ContextMenuScreen;
import de.shiewk.widgets.client.screen.WidgetSettingsScreen;
import de.shiewk.widgets.utils.WidgetUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.joml.Vector2i;

public class EditWidgetPositionsScreen
extends AnimatedScreen {
    private final class_437 parent;
    private final Consumer<ModWidget> onEdit;
    private static final int SELECT_COLOR = Color.GREEN.getRGB();
    private static final int ALIGN_COLOR = Color.ORANGE.getRGB();
    private static final int ALIGN_DISABLED_COLOR = Color.GRAY.getRGB();
    private ModWidget selectedWidget = null;
    private ModWidget hoveredWidget = null;
    private int focusedExtraX = 0;
    private int focusedExtraY = 0;
    private boolean align = true;
    private int scaledWindowWidth = 1920;
    private int scaledWindowHeight = 1080;

    public EditWidgetPositionsScreen(class_437 parent, Consumer<ModWidget> onEdit) {
        super((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions"), parent, 500);
        this.parent = parent;
        this.onEdit = onEdit;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void renderScreenContents(class_332 context, int mouseX, int mouseY, float delta) {
        this.scaledWindowWidth = context.method_51421();
        this.scaledWindowHeight = context.method_51443();
        long mt = class_156.method_648();
        this.renderAnchorArea(context, mouseX, mouseY);
        for (ModWidget widget : WidgetManager.getEnabledWidgets()) {
            int ww = (int)((float)widget.width() * widget.getScaleFactor());
            int wx = class_3532.method_15340((int)widget.getX(this.scaledWindowWidth), (int)0, (int)(this.field_22789 - ww));
            int wh = (int)((float)widget.height() * widget.getScaleFactor());
            int wy = class_3532.method_15340((int)widget.getY(this.scaledWindowHeight), (int)0, (int)(this.field_22790 - wh));
            if (this.selectedWidget == widget) {
                AlignResult alignedY;
                AlignResult alignedX = this.alignX(widget);
                if (alignedX != null) {
                    context.method_51742((int)Math.round(alignedX.result), 0, this.scaledWindowHeight, this.align ? ALIGN_COLOR : ALIGN_DISABLED_COLOR);
                }
                if ((alignedY = this.alignY(widget)) != null) {
                    context.method_51738(0, this.scaledWindowWidth, (int)Math.round(alignedY.result), this.align ? ALIGN_COLOR : ALIGN_DISABLED_COLOR);
                }
            }
            if (this.hoveredWidget == null || this.hoveredWidget == widget) {
                if (mouseX <= wx + ww && mouseX >= wx && mouseY <= wy + wh && mouseY >= wy) {
                    if (this.hoveredWidget == null) {
                        this.hoveredWidget = widget;
                    }
                } else {
                    this.hoveredWidget = null;
                }
            }
            if (this.selectedWidget == null ? this.hoveredWidget == widget : this.selectedWidget == widget) {
                context.method_73198(wx - 1, wy - 1, ww + 2, wh + 2, SELECT_COLOR);
                context.method_73198(wx, wy, ww, wh, SELECT_COLOR);
            }
            widget.render(context, mt, this.field_22793, wx, wy);
        }
        if (this.hoveredWidget != null) {
            context.method_74037(class_11876.field_62458);
        }
    }

    private boolean canAlign(int val1, int val2) {
        return (val2 - val1) * (val2 - val1) < 9;
    }

    private AlignResult alignX(ModWidget widget) {
        int widgetX = widget.getX(this.scaledWindowWidth);
        if (this.canAlign(widgetX, this.scaledWindowWidth / 2)) {
            return new AlignResult((double)this.scaledWindowWidth / 2.0, false);
        }
        if (this.canAlign(widgetX + (int)widget.scaledWidth(), this.scaledWindowWidth / 2)) {
            return new AlignResult((double)this.scaledWindowWidth / 2.0, true);
        }
        if (this.canAlign(widgetX + (int)widget.scaledWidth(), this.scaledWindowWidth / 2)) {
            return new AlignResult((double)this.scaledWindowWidth / 2.0, true);
        }
        if (this.canAlign(widgetX + (int)widget.scaledWidth() / 2, this.scaledWindowWidth / 2)) {
            return new AlignResult((double)this.scaledWindowWidth / 2.0 - (double)(widget.scaledWidth() / 2.0f), false);
        }
        if (this.canAlign(widgetX, 3)) {
            return new AlignResult(3.0, false);
        }
        if (this.canAlign((int)((float)widgetX + widget.scaledWidth()), this.scaledWindowWidth - 3)) {
            return new AlignResult(this.scaledWindowWidth - 3, true);
        }
        for (ModWidget other : WidgetManager.getEnabledWidgets()) {
            if (other == widget) continue;
            int otherX = other.getX(this.scaledWindowWidth);
            if (this.canAlign(widgetX, otherX)) {
                return new AlignResult(otherX, false);
            }
            if (this.canAlign(widgetX + (int)widget.scaledWidth(), otherX + (int)other.scaledWidth())) {
                return new AlignResult((float)otherX + other.scaledWidth(), true);
            }
            if (this.canAlign(widgetX, otherX + (int)other.scaledWidth())) {
                return new AlignResult((float)otherX + other.scaledWidth(), false);
            }
            if (!this.canAlign(widgetX + (int)widget.scaledWidth(), otherX)) continue;
            return new AlignResult(otherX, true);
        }
        return null;
    }

    private AlignResult alignY(ModWidget widget) {
        int widgetY = widget.getY(this.scaledWindowHeight);
        if (this.canAlign(widgetY, this.scaledWindowHeight / 2)) {
            return new AlignResult((double)this.scaledWindowHeight / 2.0, false);
        }
        if (this.canAlign(widgetY + (int)widget.scaledHeight(), this.scaledWindowHeight / 2)) {
            return new AlignResult((double)this.scaledWindowHeight / 2.0, true);
        }
        if (this.canAlign(widgetY + (int)widget.scaledHeight(), this.scaledWindowHeight / 2)) {
            return new AlignResult((double)this.scaledWindowHeight / 2.0, true);
        }
        if (this.canAlign(widgetY + (int)widget.scaledHeight() / 2, this.scaledWindowHeight / 2)) {
            return new AlignResult((double)this.scaledWindowHeight / 2.0 - (double)(widget.scaledHeight() / 2.0f), false);
        }
        if (this.canAlign(widgetY, 3)) {
            return new AlignResult(3.0, false);
        }
        if (this.canAlign((int)((float)widgetY + widget.scaledHeight()), this.scaledWindowHeight - 3)) {
            return new AlignResult(this.scaledWindowHeight - 3, true);
        }
        for (ModWidget other : WidgetManager.getEnabledWidgets()) {
            if (other == widget) continue;
            int otherY = other.getY(this.scaledWindowHeight);
            if (this.canAlign(widgetY, otherY)) {
                return new AlignResult(otherY, false);
            }
            if (this.canAlign(widgetY + (int)widget.scaledHeight(), otherY + (int)other.scaledHeight())) {
                return new AlignResult((float)otherY + other.scaledHeight(), true);
            }
            if (this.canAlign(widgetY, otherY + (int)other.scaledHeight())) {
                return new AlignResult((float)otherY + other.scaledHeight(), false);
            }
            if (!this.canAlign(widgetY + (int)widget.scaledHeight(), otherY)) continue;
            return new AlignResult(otherY, true);
        }
        return null;
    }

    private void renderAnchorArea(class_332 context, int mouseX, int mouseY) {
        Anchor anchor = Anchor.getAnchor(this.scaledWindowWidth, this.scaledWindowHeight, mouseX, mouseY);
        if (anchor != null) {
            Vector2i topLeft = anchor.getTopLeft(this.scaledWindowWidth, this.scaledWindowHeight);
            context.method_25294(topLeft.x, topLeft.y, topLeft.x + this.scaledWindowWidth / 3, topLeft.y + this.scaledWindowHeight / 3, 0x8FFFFFF);
        }
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.selectedWidget != null) {
            if (this.align) {
                AlignResult alignedY;
                AlignResult alignedX = this.alignX(this.selectedWidget);
                if (alignedX != null) {
                    double diff = Math.round(alignedX.result - (double)this.selectedWidget.getX(this.scaledWindowWidth));
                    if (alignedX.isEnd) {
                        diff -= (double)this.selectedWidget.scaledWidth();
                    }
                    this.selectedWidget.move((int)diff, 0);
                }
                if ((alignedY = this.alignY(this.selectedWidget)) != null) {
                    double diff = Math.round(alignedY.result - (double)this.selectedWidget.getY(this.scaledWindowHeight));
                    if (alignedY.isEnd) {
                        diff -= (double)this.selectedWidget.scaledHeight();
                    }
                    this.selectedWidget.move(0, (int)diff);
                }
            }
            this.onEdit.accept(this.selectedWidget);
            this.selectedWidget = null;
        }
        return super.method_25406(click);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0 && this.hoveredWidget != null) {
            this.selectedWidget = this.hoveredWidget;
            this.focusedExtraX = (int)(click.comp_4798() - (double)this.hoveredWidget.getX(this.scaledWindowWidth));
            this.focusedExtraY = (int)(click.comp_4799() - (double)this.hoveredWidget.getY(this.scaledWindowHeight));
        } else if (click.method_74245() == 1) {
            int x = (int)click.comp_4798();
            int y = (int)click.comp_4799();
            ModWidget hovered = this.hoveredWidget;
            WidgetUtils.playSound(class_3417.field_46934);
            assert (this.field_22787 != null);
            if (hovered != null) {
                this.field_22787.method_1507((class_437)new ContextMenuScreen((class_2561)class_2561.method_43473(), this, x, y, List.of(new ContextMenuScreen.Option((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.menu.widgetSettings"), () -> this.field_22787.method_1507((class_437)new WidgetSettingsScreen(this, hovered, this.onEdit))), new ContextMenuScreen.Option((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.menu.setAnchor"), () -> {
                    ObjectArrayList options = new ObjectArrayList(Anchor.values().length);
                    for (Anchor anchor : Anchor.values()) {
                        options.add(new ContextMenuScreen.Option((class_2561)class_2561.method_43471((String)("widgets.ui.anchor." + anchor.name().toLowerCase(Locale.ROOT))), hovered.getSettings().anchor == anchor, () -> {
                            hovered.setPos(anchor, hovered.getX(this.scaledWindowWidth) - anchor.getAlignStartPosX(this.scaledWindowWidth), hovered.getY(this.scaledWindowHeight) - anchor.getAlignStartPosY(this.scaledWindowHeight));
                            this.onEdit.accept(hovered);
                        }));
                    }
                    this.field_22787.method_1507((class_437)new ContextMenuScreen((class_2561)class_2561.method_43473(), this, x, y, (List<ContextMenuScreen.Option>)options));
                }), new ContextMenuScreen.Option((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.menu.removeWidget"), () -> {
                    hovered.getSettings().toggleEnabled(hovered);
                    this.onEdit.accept(hovered);
                }))));
            } else {
                this.field_22787.method_1507((class_437)new ContextMenuScreen((class_2561)class_2561.method_43473(), this, x, y, List.of(new ContextMenuScreen.Option((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.menu.addWidget"), () -> {
                    ObjectArrayList options = new ObjectArrayList();
                    for (ModWidget widget : WidgetManager.getAllWidgets()) {
                        if (widget.getSettings().isEnabled()) continue;
                        options.add(new ContextMenuScreen.Option(widget.getName(), () -> {
                            widget.getSettings().setEnabled(widget, true);
                            widget.setAbsolutePos(x, y, this.scaledWindowWidth, this.scaledWindowHeight);
                            this.onEdit.accept(widget);
                        }));
                    }
                    this.field_22787.method_1507((class_437)new ContextMenuScreen((class_2561)class_2561.method_43473(), this, x, y, (List<ContextMenuScreen.Option>)options));
                }))));
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (click.method_74245() == 0) {
            assert (this.field_22787 != null);
            ModWidget widget = this.selectedWidget;
            if (widget != null) {
                WidgetSettings settings = widget.getSettings();
                int ww = (int)((float)widget.width() * widget.getScaleFactor());
                int wx = class_3532.method_15340((int)widget.getX(this.scaledWindowWidth), (int)0, (int)(this.field_22789 - ww));
                int wh = (int)((float)widget.height() * widget.getScaleFactor());
                int wy = class_3532.method_15340((int)widget.getY(this.scaledWindowHeight), (int)0, (int)(this.field_22790 - wh));
                if (click.comp_4798() <= (double)(wx + ww) + deltaX && click.comp_4798() >= (double)wx + deltaX && click.comp_4799() <= (double)(wy + wh) + deltaY && click.comp_4799() >= (double)wy + deltaY) {
                    Anchor anchor = Anchor.getAnchor(this.scaledWindowWidth, this.scaledWindowHeight, (int)click.comp_4798(), (int)click.comp_4799());
                    if (anchor == null) {
                        return false;
                    }
                    int newOffX = (int)(click.comp_4798() - (double)anchor.getAlignStartPosX(this.scaledWindowWidth)) - this.focusedExtraX;
                    int newOffY = (int)(click.comp_4799() - (double)anchor.getAlignStartPosY(this.scaledWindowHeight)) - this.focusedExtraY;
                    settings.setPos(anchor, newOffX, newOffY);
                    if (widget.getX(this.scaledWindowWidth) + ww > this.scaledWindowWidth) {
                        settings.setPos(anchor, newOffX -= widget.getX(this.scaledWindowWidth) - this.scaledWindowWidth + ww, newOffY);
                    }
                    if (widget.getX(this.scaledWindowWidth) < 0) {
                        settings.setPos(anchor, newOffX -= widget.getX(this.scaledWindowWidth), newOffY);
                    }
                    if (widget.getY(this.scaledWindowHeight) + wh > this.scaledWindowHeight) {
                        settings.setPos(anchor, newOffX, newOffY -= widget.getY(this.scaledWindowHeight) - this.scaledWindowHeight + wh);
                    }
                    if (widget.getY(this.scaledWindowHeight) < 0) {
                        settings.setPos(anchor, newOffX, newOffY -= widget.getY(this.scaledWindowHeight));
                    }
                    return true;
                }
            }
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43469((String)"widgets.ui.editPositions.snap", (Object[])new Object[]{this.align ? class_2561.method_43471((String)"gui.yes") : class_2561.method_43471((String)"gui.no")}), button -> {
            this.align = !this.align;
            button.method_25355((class_2561)class_2561.method_43469((String)"widgets.ui.editPositions.snap", (Object[])new Object[]{this.align ? class_2561.method_43471((String)"gui.yes") : class_2561.method_43471((String)"gui.no")}));
        }).method_46433(this.field_22789 / 2 - 75, this.field_22790 / 2 - 10).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"widgets.ui.editPositions.snap.help"))).method_46431());
    }

    private record AlignResult(double result, boolean isEnd) {
    }
}

