/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.utils.WidgetUtils;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_9191;

public class PingWidget
extends BasicTextWidget {
    private boolean dynamicColor = false;
    private boolean hideInSingleplayer = false;
    long lastPingQuery = 0L;

    public PingWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("dynamic_color", (class_2561)class_2561.method_43471((String)"widgets.widgets.ping.dynamicColor"), true), new ToggleWidgetSetting("hide_in_singleplayer", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.hideInSingleplayer"), false)));
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.dynamicColor && !this.rainbow);
        this.getSettings().optionById("rainbow").setShowCondition(() -> !this.dynamicColor);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> !this.dynamicColor && this.rainbow);
    }

    @Override
    public void tickWidget() {
        boolean bl = this.shouldRender = !this.hideInSingleplayer || !WidgetUtils.isInSingleplayer();
        if (!this.shouldRender) {
            return;
        }
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null) {
            if (this.lastPingQuery < class_156.method_658() - 5000L) {
                networkHandler.field_45946.method_53486();
                this.lastPingQuery = class_156.method_658();
            }
            class_9191 pingLog = networkHandler.field_45946.field_45949;
            int logLength = pingLog.method_56663();
            int avgCompileLength = 3;
            long ping = 0L;
            int valuesRead = 0;
            for (int i = logLength - 1; i > logLength - 3 - 1 && i >= 0; --i) {
                ping += pingLog.method_56659(i);
                ++valuesRead;
            }
            if (valuesRead == 0) {
                this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)"??? ms"));
                if (this.dynamicColor) {
                    this.textColor = -16711936;
                }
                return;
            }
            long avgPing = ping / (long)valuesRead;
            this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)(avgPing + " ms")));
            if (this.dynamicColor) {
                this.textColor = avgPing < 50L ? -16711936 : (avgPing < 120L ? -256 : -53200);
            }
        }
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.dynamicColor = ((ToggleWidgetSetting)settings.optionById("dynamic_color")).getValue();
        this.hideInSingleplayer = ((ToggleWidgetSetting)settings.optionById("hide_in_singleplayer")).getValue();
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.ping");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.ping.description");
    }
}

