/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets;

import de.shiewk.widgets.WidgetSettings;
import de.shiewk.widgets.widgets.BasicTextWidget;
import de.shiewk.widgets.widgets.settings.IntSliderWidgetSetting;
import de.shiewk.widgets.widgets.settings.ToggleWidgetSetting;
import java.util.List;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8915;

public class TPSWidget
extends BasicTextWidget {
    public static final TPSWidget INSTANCE = new TPSWidget(class_2960.method_60655((String)"widgets", (String)"tps"));
    private static long[] lastUpdates = new long[5];
    private static int updatePointer = 0;
    private static int updatesSinceWorldChange = 0;
    private boolean dynamicColor = true;
    private boolean showLabel = true;

    private TPSWidget(class_2960 id) {
        super(id, List.of(new ToggleWidgetSetting("show_label", (class_2561)class_2561.method_43471((String)"widgets.widgets.common.showLabel"), true), new ToggleWidgetSetting("dynamic_color", (class_2561)class_2561.method_43471((String)"widgets.widgets.tps.dynamicColor"), true), new IntSliderWidgetSetting("window_size", (class_2561)class_2561.method_43471((String)"widgets.widgets.tps.windowSize"), 2, 5, 20)));
        this.getSettings().optionById("textcolor").setShowCondition(() -> !this.dynamicColor && !this.rainbow);
        this.getSettings().optionById("rainbow").setShowCondition(() -> !this.dynamicColor);
        this.getSettings().optionById("rainbow_speed").setShowCondition(() -> !this.dynamicColor && this.rainbow);
    }

    public static void worldChanged() {
        updatesSinceWorldChange = 0;
    }

    public static void worldTimeUpdated(long nanoTime) {
        class_310 client = class_310.method_1551();
        if (client.method_1542()) {
            class_1132 server = client.method_1576();
            if (server != null) {
                class_8915 tickManager = server.method_54833();
                float tps = 1000.0f / server.method_54832();
                float targetTickRate = tickManager.method_54748();
                if (tickManager.method_54670()) {
                    INSTANCE.updateTPS(tps, targetTickRate, true);
                } else {
                    INSTANCE.updateTPS(Math.min(tps, targetTickRate), targetTickRate, true);
                }
            }
        } else {
            boolean loadingFinished;
            ++updatesSinceWorldChange;
            TPSWidget.lastUpdates[TPSWidget.updatePointer] = nanoTime;
            if (++updatePointer >= lastUpdates.length) {
                updatePointer = 0;
            }
            long totalDifference = 0L;
            for (int i = 0; i < lastUpdates.length - 1; ++i) {
                long difference = lastUpdates[(updatePointer + i + 1) % lastUpdates.length] - lastUpdates[(updatePointer + i) % lastUpdates.length];
                totalDifference += difference;
            }
            long avgDifference = totalDifference / (long)(lastUpdates.length - 1);
            float mspt = (float)avgDifference / 2.0E7f;
            float ticksPerSecond = 1000.0f / mspt;
            boolean bl = loadingFinished = updatesSinceWorldChange > lastUpdates.length;
            if (client.field_1687 != null) {
                INSTANCE.updateTPS(ticksPerSecond, client.field_1687.method_54719().method_54748(), loadingFinished);
            } else {
                INSTANCE.updateTPS(ticksPerSecond, 20.0f, loadingFinished);
            }
        }
    }

    private void updateTPS(float tps, float targetTickRate, boolean loadingFinished) {
        if (!loadingFinished) {
            if (this.showLabel) {
                this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)class_2561.method_43469((String)"widgets.widgets.tps.tps", (Object[])new Object[]{"???"}).getString()));
            } else {
                this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)"???"));
            }
            if (this.dynamicColor) {
                this.textColor = -16711936;
            }
        } else {
            tps = (float)Math.round(tps * 10.0f) / 10.0f;
            if (this.showLabel) {
                this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)class_2561.method_43469((String)"widgets.widgets.tps.tps", (Object[])new Object[]{Float.valueOf(tps)}).getString()));
            } else {
                this.formatAndSetRenderText((class_2561)class_2561.method_43470((String)String.valueOf(tps)));
            }
            if (this.dynamicColor) {
                this.textColor = (double)tps >= (double)targetTickRate * 0.99 ? -16711936 : ((double)tps >= (double)targetTickRate * 0.74 ? -256 : -65536);
            }
        }
    }

    @Override
    public void tickWidget() {
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"widgets.widgets.tps");
    }

    @Override
    public class_2561 getDescription() {
        return class_2561.method_43471((String)"widgets.widgets.tps.description");
    }

    @Override
    public void onSettingsChanged(WidgetSettings settings) {
        super.onSettingsChanged(settings);
        this.dynamicColor = ((ToggleWidgetSetting)settings.optionById("dynamic_color")).getValue();
        this.showLabel = ((ToggleWidgetSetting)settings.optionById("show_label")).getValue();
        int windowSize = ((IntSliderWidgetSetting)settings.optionById("window_size")).getValue();
        updatePointer = 0;
        updatesSinceWorldChange = 0;
        lastUpdates = new long[windowSize];
    }
}

