/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.widgets.widgets.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.shiewk.widgets.WidgetSettingOption;
import de.shiewk.widgets.utils.WidgetUtils;
import java.awt.Color;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class RGBAColorWidgetSetting
extends WidgetSettingOption {
    private int r;
    private int g;
    private int b;
    private int a;

    public RGBAColorWidgetSetting(String id, class_2561 name, int defaultR, int defaultG, int defaultB, int defaultAlpha) {
        super(id, name);
        this.r = defaultR;
        this.g = defaultG;
        this.b = defaultB;
        this.a = defaultAlpha;
    }

    @Override
    public JsonElement saveState() {
        return new JsonPrimitive((Number)this.getColor());
    }

    public int getColor() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public void loadState(JsonElement state) {
        if (state.isJsonPrimitive() && state.getAsJsonPrimitive().isNumber()) {
            Color color = new Color(state.getAsJsonPrimitive().getAsInt(), true);
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
            this.a = color.getAlpha();
        }
    }

    public int method_25368() {
        return 72;
    }

    public int method_25364() {
        return 24;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.getColor());
        context.method_51738(this.method_46426(), this.method_46426() + this.method_25368(), this.method_46427(), this.getColor() | 0xFF000000);
        context.method_51738(this.method_46426(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.getColor() | 0xFF000000);
        context.method_51742(this.method_46426(), this.method_46427(), this.method_46427() + this.method_25364(), this.getColor() | 0xFF000000);
        context.method_51742(this.method_46426() + this.method_25368(), this.method_46427(), this.method_46427() + this.method_25364(), this.getColor() | 0xFF000000);
        String colorText = "#" + this.toHexString();
        int width = textRenderer.method_1727(colorText);
        context.method_51433(textRenderer, colorText, this.method_46426() + (this.method_25368() / 2 - width / 2), this.method_46427() + (this.method_25364() / 2 - 4), -1, true);
        if (this.isHovered(mouseX, mouseY)) {
            context.method_74037(class_11876.field_62455);
        }
    }

    private String toHexSingle(int comp) {
        String s = Integer.toHexString(comp);
        return "0".repeat(2 - s.length()) + s;
    }

    public String toHexString() {
        return this.toHexSingle(this.r) + this.toHexSingle(this.g) + this.toHexSingle(this.b) + this.toHexSingle(this.a);
    }

    @Override
    public boolean mouseClicked(class_11909 click, boolean doubled) {
        class_310 client = class_310.method_1551();
        WidgetUtils.playSound(class_3417.field_46934);
        client.method_1507((class_437)new ChangeScreen(client.field_1755, (int)client.field_1729.method_68879(client.method_22683()), (int)client.field_1729.method_68883(client.method_22683())));
        return true;
    }

    public class ChangeScreen
    extends class_437 {
        private final class_437 parent;
        private int x;
        private int y;
        private static final int PADDING = 16;
        private static final int BAR_WIDTH = 18;
        private static final int BAR_HEIGHT = 147;
        private static final int RECT_WIDTH = 152;
        private static final int RECT_HEIGHT = 179;

        protected ChangeScreen(class_437 parent, int x, int y) {
            super((class_2561)class_2561.method_43473());
            this.parent = parent;
            this.x = x;
            this.y = y;
        }

        protected void method_25426() {
            super.method_25426();
            if (this.y + 179 > this.field_22790) {
                this.y = this.field_22790 - 179;
            }
            if (this.x + 152 > this.field_22789) {
                this.x = this.field_22789 - 152;
            }
            this.method_37063((class_364)new ColorBar(this.x + 16, this.y + 16, 18, 147, 0));
            this.method_37063((class_364)new ColorBar(this.x + 32 + 18, this.y + 16, 18, 147, 1));
            this.method_37063((class_364)new ColorBar(this.x + 48 + 36, this.y + 16, 18, 147, 2));
            this.method_37063((class_364)new ColorBar(this.x + 64 + 54, this.y + 16, 18, 147, 3));
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            this.parent.method_25394(context, 0, 0, deltaTicks);
            context.method_25294(this.x, this.y, this.x + 152, this.y + 179, -1073741824);
            context.method_73198(this.x, this.y, 152, 179, 0x67FFFFFF);
            super.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        public void method_25419() {
            this.field_22787.method_1507(this.parent);
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            if (click.comp_4798() < (double)this.x || click.comp_4799() < (double)this.y || click.comp_4798() > (double)(this.x + 152) || click.comp_4799() > (double)(this.y + 179)) {
                this.method_25419();
                WidgetUtils.playSound(class_3417.field_46935);
                return false;
            }
            return super.method_25402(click, doubled);
        }

        public class ColorBar
        extends class_339 {
            private final int component;

            public ColorBar(int x, int y, int width, int height, int component) {
                super(x, y, width, height, (class_2561)class_2561.method_43473());
                this.component = component;
            }

            public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
                if (this.method_49606()) {
                    this.setValue((int)((double)this.getValue() + verticalAmount * 2.0));
                    return true;
                }
                return false;
            }

            public int getValue() {
                return switch (this.component) {
                    case 0 -> RGBAColorWidgetSetting.this.r;
                    case 1 -> RGBAColorWidgetSetting.this.g;
                    case 2 -> RGBAColorWidgetSetting.this.b;
                    case 3 -> RGBAColorWidgetSetting.this.a;
                    default -> throw new IllegalStateException("Component out of range: " + this.component);
                };
            }

            public void setValue(int val) {
                val = class_3532.method_15340((int)val, (int)0, (int)255);
                switch (this.component) {
                    case 0: {
                        RGBAColorWidgetSetting.this.r = val;
                        break;
                    }
                    case 1: {
                        RGBAColorWidgetSetting.this.g = val;
                        break;
                    }
                    case 2: {
                        RGBAColorWidgetSetting.this.b = val;
                        break;
                    }
                    case 3: {
                        RGBAColorWidgetSetting.this.a = val;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Component out of range: " + this.component);
                    }
                }
            }

            protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
                context.method_25296(this.method_46426() + 2, this.method_46427() + 10, this.method_46426() + this.method_25368() - 2, this.method_46427() + this.method_25364() - 10, this.topColor(), this.bottomColor());
                context.method_51738(this.method_46426(), this.method_46426() + this.method_25368() - 1, this.method_46427() + 10 + (255 - this.getValue()) / 2, -1);
                Object text = "" + this.getValue();
                int textWidth = ChangeScreen.this.field_22793.method_1727((String)text);
                context.method_51433(ChangeScreen.this.field_22793, (String)text, this.method_46426() + (this.method_25368() / 2 - textWidth / 2), this.method_46427() - 2, -1, true);
                text = this.componentLabel();
                textWidth = ChangeScreen.this.field_22793.method_1727((String)text);
                context.method_51433(ChangeScreen.this.field_22793, (String)text, this.method_46426() + (this.method_25368() / 2 - textWidth / 2), this.method_46427() + 142, -1, true);
                if (this.method_49606()) {
                    context.method_74037(class_11876.field_62456);
                }
            }

            private String componentLabel() {
                return switch (this.component) {
                    case 0 -> "R";
                    case 1 -> "G";
                    case 2 -> "B";
                    case 3 -> "A";
                    default -> throw new IllegalStateException("Component out of range: " + this.component);
                };
            }

            public boolean method_25402(class_11909 click, boolean doubled) {
                return this.method_25403(click, 0.0, 0.0);
            }

            public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
                if (this.method_49606()) {
                    double pos = click.comp_4799() - (double)this.method_46427() - 10.0;
                    int val = (int)(255.0 - pos * 2.0);
                    this.setValue(val);
                    return true;
                }
                return false;
            }

            private int componentMask() {
                return switch (this.component) {
                    case 0 -> 0xFF0000;
                    case 1 -> 65280;
                    case 2 -> 255;
                    case 3 -> -16777216;
                    default -> throw new IllegalStateException("Component out of range: " + this.component);
                };
            }

            public boolean method_25404(class_11908 input) {
                if (input.method_74234()) {
                    this.setValue(this.getValue() + 1);
                    return true;
                }
                if (input.method_74235()) {
                    this.setValue(this.getValue() - 1);
                    return true;
                }
                return super.method_25404(input);
            }

            private int bottomColor() {
                return RGBAColorWidgetSetting.this.getColor() & ~this.componentMask();
            }

            private int topColor() {
                return RGBAColorWidgetSetting.this.getColor() | this.componentMask();
            }

            protected void method_47399(class_6382 builder) {
            }
        }
    }
}

