package net.earlystage.block;

import java.util.List;
import java.util.Optional;

import net.earlystage.block.entity.CraftingRockBlockEntity;
import net.earlystage.block.inventory.CraftingRockInventory;
import net.earlystage.init.BlockInit;
import net.earlystage.init.ConfigInit;
import net.earlystage.init.TagInit;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792.class_9635;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_8786;
import net.minecraft.class_9062;

public class CraftingRockBlock extends class_2248 implements class_2343 {

    public static final class_2753 FACING = class_2383.field_11177;
    private static final class_265 BOTTOM_SHAPE = class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);

    public CraftingRockBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CraftingRockBlockEntity(pos, state);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BOTTOM_SHAPE;
    }

    @Override
    public boolean method_9526(class_2680 state) {
        return true;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042());
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            class_1263 inventory = (class_1263) world.method_8321(pos);
            if (Math.abs(hit.method_17784().method_10214() % 1) < 0.505D && Math.abs(hit.method_17784().method_10214() % 1) > 0.495D) {
                if (itemStack.method_31573(TagInit.ROCK_ITEMS)) {
                    if (!inventory.method_5442()) {
                        if (!world.method_8608()) {
                            if (((CraftingRockBlockEntity) blockEntity).getCraftHits() - 1 <= 0) {
                                tryCraftItem(world, player, (CraftingRockBlockEntity) blockEntity);
                                ((CraftingRockBlockEntity) blockEntity).setCraftHits(ConfigInit.CONFIG.craftRockCraftHits + world.method_8409().method_43048(ConfigInit.CONFIG.craftRockCraftHits / 2));
                            } else {
                                ((CraftingRockBlockEntity) blockEntity).decreaseCraftHits(player);
                            }
                        }
                        world.method_8396(player, pos, class_3417.field_14658, class_3419.field_15245, 1.0f, 1.0f);
                        return class_9062.method_55644(world.method_8608());
                    }
                    return class_9062.field_47733;
                }
                double xPos = hit.method_17784().method_10216() < 0D ? 1.0D + hit.method_17784().method_10216() % 1 : hit.method_17784().method_10216() % 1;
                double zPos = hit.method_17784().method_10215() < 0D ? 1.0D + hit.method_17784().method_10215() % 1 : hit.method_17784().method_10215() % 1;
                int slot = getSlot(xPos, zPos);
                if (inventory.method_5438(slot).method_7960() && !itemStack.method_7960() && itemStack.method_31573(TagInit.USABLE_CRAFTING_ROCK_ITEMS)) {
                    if (!world.method_8608()) {
                        inventory.method_5447(slot, new class_1799(itemStack.method_7909(), 1));
                        if (!player.method_7337()) {
                            itemStack.method_7934(1);
                        }
                        ((CraftingRockBlockEntity) blockEntity).setCraftHits(ConfigInit.CONFIG.craftRockCraftHits + world.method_8409().method_43048(ConfigInit.CONFIG.craftRockCraftHits / 2));
                    }
                    return class_9062.method_55644(world.method_8608());
                } else if (!inventory.method_5438(slot).method_7960()) {
                    if (!world.method_8608()) {
                        if (!player.method_7337()) {
                            player.method_31548().method_7398(inventory.method_5438(slot));
                        }
                        inventory.method_5447(slot, new class_1799(class_1802.field_8162));
                        ((CraftingRockBlockEntity) blockEntity).setCraftHits(ConfigInit.CONFIG.craftRockCraftHits + world.method_8409().method_43048(ConfigInit.CONFIG.craftRockCraftHits / 2));
                    }
                    return class_9062.method_55644(world.method_8608());
                }
            }
        }
        return class_9062.field_47733;
    }

    private int getSlot(double x, double z) {
        int slot = 0;
        for (int i = 2; i >= 0; i--) {
            for (int u = 2; u >= 0; u--) {
                if (x > i * 0.33D && z > u * 0.33D) {
                    return slot;
                }
                slot++;
            }
        }
        return 0;
    }

    private void tryCraftItem(class_1937 world, class_1657 player, CraftingRockBlockEntity blockEntity) {
        if (!world.method_8608()) {
            CraftingRockInventory craftingInventory = null;
            Optional<class_8786<class_3955>> optional = null;
            for (int i = 0; i < 4; i++) {
                craftingInventory = new CraftingRockInventory(blockEntity, i);
                optional = world.method_8503().method_3772().method_8132(class_3956.field_17545, craftingInventory.method_59961(), world);
                if (optional.isPresent()) {
                    break;
                }
            }
            if (optional != null && optional.isPresent() && (optional.get().comp_1933().method_8118() || !world.method_8450().method_8355(class_1928.field_19407)
                    || ((class_3222) player).method_14253().method_14878(optional.get()))) {
                blockEntity.method_5448();
                blockEntity.method_5447(4, optional.get().comp_1933().method_8116(craftingInventory.method_59961(), world.method_30349()));
            }
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CraftingRockBlockEntity) {
            class_1264.method_5451(world, pos, (class_1263) ((CraftingRockBlockEntity) blockEntity));
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public void method_9568(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 options) {
        if (ConfigInit.CONFIG.info_tooltips) {
            tooltip.add(class_2561.method_43471("earlystage.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("earlystage.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("block.earlystage.crafting_rock.tooltip"));
            }
        }
        super.method_9568(stack, context, tooltip, options);
    }

}
