package net.earlystage.block;

import org.jetbrains.annotations.Nullable;

import net.earlystage.block.entity.SieveBlockEntity;
import net.earlystage.init.BlockInit;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9062;

public class RedstoneSieveBlock extends SieveBlock {

    public static final class_2746 POWERED = class_2741.field_12484;

    public RedstoneSieveBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(POWERED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(POWERED, ctx.method_8045().method_49803(ctx.method_8037())).method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return checkType(type, BlockInit.SIEVE_ENTITY, world.method_8608() ? SieveBlockEntity::clientTick : SieveBlockEntity::serverTick);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (!world.method_8608()) {
            boolean bl = state.method_11654(POWERED);
            if (bl != world.method_49803(pos)) {
                if (bl) {
                    world.method_39279(pos, this, 4);
                } else {
                    world.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
                }
            }
        }
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);

    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(POWERED).booleanValue() && !world.method_49803(pos)) {
            world.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWERED);
        super.method_9515(builder);
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            class_1263 inventory = (class_1263) world.method_8321(pos);
            class_1799 blockStack = inventory.method_5438(0);
            if (blockStack.method_7960()) {
                if (inventory.method_5437(0, itemStack)) {
                    ((SieveBlockEntity) blockEntity).refreshSieveCount();
                    if (!world.method_8608()) {
                        inventory.method_5447(0, new class_1799(itemStack.method_7909(), 1));
                        if (!player.method_7337())
                            itemStack.method_7934(1);
                    }
                    return class_9062.method_55644(world.method_8608());
                }
                return class_9062.field_47733;
            } else {
                if (itemStack.method_7960()) {
                    if (!world.method_8608()) {
                        player.method_6122(hand, blockStack);
                        inventory.method_5448();
                    }
                    return class_9062.method_55644(world.method_8608());
                }
            }
        }
        return class_9062.field_47733;
    }

    @SuppressWarnings("unchecked")
    @Nullable
    private static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? (class_5558<A>) ticker : null;
    }

}
