package net.earlystage.block.entity;

import net.earlystage.init.BlockInit;
import net.earlystage.init.ConfigInit;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225.class_7874;

public class CraftingRockBlockEntity extends class_2586 implements class_1263 {

    private class_2371<class_1799> inventory;
    private int craftHits = 0;
    private int totalHits = 0;

    public CraftingRockBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.CRAFTING_ROCK_ENTITY, pos, state);
        this.inventory = class_2371.method_10213(9, class_1799.field_8037);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        inventory.clear();
        class_1262.method_5429(nbt, inventory, registryLookup);
        this.craftHits = nbt.method_10550("CraftHits");
        this.totalHits = nbt.method_10550("TotalHits");
    }

    @Override
    public void method_11007(class_2487 nbt, class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426(nbt, inventory, registryLookup);
        nbt.method_10569("CraftHits", this.craftHits);
        nbt.method_10569("TotalHits", this.totalHits);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        sendUpdate();
    }

    public void setCraftHits(int hits) {
        this.craftHits = hits;
    }

    public int getCraftHits() {
        return this.craftHits;
    }

    public void decreaseCraftHits(class_1297 entity) {
        this.craftHits--;
        this.totalHits++;
        if (!this.field_11863.field_9236 && ConfigInit.CONFIG.craftRockMaxCraftHits <= this.totalHits) {
            this.field_11863.method_8651(field_11867, false, entity);
        }
    }

    private void sendUpdate() {
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            (this.field_11863).method_8413(this.field_11867, state, state, 3);
        }
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    @Override
    public int method_5439() {
        return 9;
    }

    @Override
    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return this.inventory.get(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, slot, 1);
        this.method_5431();
        return result;
    }

    @Override
    public class_1799 method_5441(int slot) {
        this.method_5431();
        return class_1262.method_5428(this.inventory, slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, stack);
        this.method_5431();
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        // if (this.isEmpty() && this.world.getBlockState(pos.up()).isAir())
        // for (int i = 0; i < EarlyStageMain.SIEVE_DROP_TEMPLATES.size(); i++)
        // if (stack.getItem().equals(EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockItem()))
        // return true;
        return true;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

}
