package net.earlystage.block.entity;

import net.earlystage.EarlyStageMain;
import net.earlystage.data.SieveDropTemplate;
import net.earlystage.init.BlockInit;
import net.earlystage.init.ConfigInit;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225.class_7874;

public class SieveBlockEntity extends class_2586 implements class_1263 {

    private int tick;
    private class_2371<class_1799> inventory;
    private int sieveCount;

    public SieveBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.SIEVE_ENTITY, pos, state);
        this.inventory = class_2371.method_10213(1, class_1799.field_8037);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        inventory.clear();
        class_1262.method_5429(nbt, inventory, registryLookup);
        sieveCount = nbt.method_10550("SieveCount");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426(nbt, inventory, registryLookup);
        nbt.method_10569("SieveCount", sieveCount);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, SieveBlockEntity blockEntity) {
        blockEntity.update();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SieveBlockEntity blockEntity) {
        blockEntity.update();
    }

    private void update() {
        if (!this.method_5442() && field_11863.method_49803(field_11867)) {
            this.tick++;
            if (this.tick >= ConfigInit.CONFIG.redstoneSieveTicks) {
                this.sieve();
                this.tick = 0;
            }
        } else if (this.tick != 0)
            this.tick = 0;
    }

    public int getSieveCount() {
        return this.sieveCount;
    }

    public void refreshSieveCount() {
        this.sieveCount = 0;
    }

    public void sieve() {
        this.sieveCount++;
        if (this.sieveCount > 3) {
            if (!field_11863.field_9236) {
                for (int i = 0; i < EarlyStageMain.SIEVE_DROP_TEMPLATES.size(); i++) {
                    if (EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockItem().equals(this.method_5438(0).method_7909())) {
                        SieveDropTemplate sieveDropTemplate = EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i);

                        for (int u = 0; u < sieveDropTemplate.getBlockDrops().size(); u++) {
                            for (int k = 0; k < sieveDropTemplate.getRollCount().get(u); k++) {
                                if (this.field_11863.field_9229.method_43057() <= sieveDropTemplate.getDropChances().get(u))
                                    dropItem(sieveDropTemplate.getBlockDrops().get(u));
                            }
                        }
                        break;
                    }
                }
                this.method_5448();
            }
            field_11863.method_8396(null, field_11867, class_3417.field_17606, class_3419.field_15245, 1.0f, 1.0f);
        } else
            field_11863.method_8396(null, field_11867, class_3417.field_17607, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void dropItem(class_1792 item) {
        double d = (double) (field_11863.field_9229.method_43057() * 0.7f) + (double) 0.15f;
        double e = (double) (field_11863.field_9229.method_43057() * 0.7f) + 0.06000000238418579 + 0.6;
        double g = (double) (field_11863.field_9229.method_43057() * 0.7f) + (double) 0.15f;

        class_1542 itemEntity = new class_1542(field_11863, (double) field_11867.method_10263() + d, (double) field_11867.method_10264() + e, (double) field_11867.method_10260() + g, new class_1799(item));
        itemEntity.method_6988();
        field_11863.method_8649(itemEntity);
    }

    @Override
    public void method_5431() {
        super.method_5431();
        sendUpdate();
    }

    private void sendUpdate() {
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            (this.field_11863).method_8413(this.field_11867, state, state, 3);
        }
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5442() {
        return this.method_5438(0).method_7960();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return this.inventory.get(0);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, slot, 1);
        this.method_5431();
        return result;
    }

    @Override
    public class_1799 method_5441(int slot) {
        this.method_5431();
        return class_1262.method_5428(this.inventory, slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(0, stack);
        this.refreshSieveCount();
        this.method_5431();
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if (this.method_5442() && this.field_11863.method_8320(field_11867.method_10084()).method_26215())
            for (int i = 0; i < EarlyStageMain.SIEVE_DROP_TEMPLATES.size(); i++)
                if (stack.method_7909().equals(EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockItem()))
                    return true;
        return false;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

}
