package net.earlystage.block.inventory;

import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class CraftingRockInventory extends class_1715 {

    private final class_2371<class_1799> stacks;

    public CraftingRockInventory(class_1263 inventory, int variant) {
        super(null, 3, 3);
        stacks = class_2371.method_10213(9, class_1799.field_8037);

        for (int i = 0; i < inventory.method_5439(); i++) {
            this.stacks.set(getSlot(variant, i), inventory.method_5438(i));
        }
    }

    @Override
    public int method_5439() {
        return this.stacks.size();
    }

    @Override
    public boolean method_5442() {
        for (class_1799 itemStack : this.stacks) {
            if (itemStack.method_7960())
                continue;
            return false;
        }
        return true;
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= this.method_5439()) {
            return class_1799.field_8037;
        }
        return this.stacks.get(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.stacks, slot, amount);
        return itemStack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.stacks, slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.stacks.set(slot, stack);
    }

    @Override
    public void method_5448() {
        this.stacks.clear();
    }

    @Override
    public List<class_1799> method_51305() {
        return List.copyOf(this.stacks);
    }

    private int getSlot(int variant, int i) {
        if (variant == 0)
            return i;
        else if (variant == 1)
            return Math.abs(i - 8);
        else if (variant == 2) {
            switch (i) {
            case 0:
                return 6;
            case 1:
                return 3;
            case 2:
                return 0;
            case 3:
                return 7;
            case 4:
                return 4;
            case 5:
                return 1;
            case 6:
                return 8;
            case 7:
                return 5;
            case 8:
                return 2;
            default:
                return 0;
            }
        } else if (variant == 3) {
            switch (i) {
            case 0:
                return 2;
            case 1:
                return 5;
            case 2:
                return 8;
            case 3:
                return 1;
            case 4:
                return 4;
            case 5:
                return 7;
            case 6:
                return 0;
            case 7:
                return 3;
            case 8:
                return 6;
            default:
                return 0;
            }
        }
        return 0;
    }

}
