package net.earlystage.compat;

import java.util.ArrayList;
import java.util.List;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiStack;
import net.earlystage.init.BlockInit;
import net.earlystage.init.RecipeInit;
import net.earlystage.init.RenderInit;
import net.earlystage.misc.ExtraBlastingRecipe;
import net.minecraft.class_1863;
import net.minecraft.class_1869;
import net.minecraft.class_2960;
import net.minecraft.class_8786;

public class EarlyStageEmiPlugin implements EmiPlugin {

    public static final EmiStack CRAFTING_ROCK = EmiStack.of(BlockInit.CRAFTING_ROCK.method_8389());
    public static final EmiRecipeCategory CRAFTING_ROCK_CATEGORY = new EmiRecipeCategory(class_2960.method_60655("earlystage", "crafting_rock"), CRAFTING_ROCK,
            new EmiTexture(RenderInit.GUI_ICON_TEXTURES, 18, 0, 16, 16));

    @Override
    public void register(EmiRegistry emiRegistry) {
        class_1863 manager = emiRegistry.getRecipeManager();
        for (class_8786<ExtraBlastingRecipe> recipe : manager.method_30027(RecipeInit.EXTRA_BLASTING)) {
            emiRegistry.addRecipe(new ExtraBlastingEmiRecipe(recipe.comp_1933()));
        }
        emiRegistry.addCategory(CRAFTING_ROCK_CATEGORY);
        emiRegistry.addWorkstation(CRAFTING_ROCK_CATEGORY, CRAFTING_ROCK);

        for (class_1869 recipe : getDefaultRockRecipes(manager)) {
            emiRegistry.addRecipe(new RockEmiRecipe(recipe));
        }
    }

    private static final List<class_1869> getDefaultRockRecipes(class_1863 manager) {
        List<class_1869> list = new ArrayList<class_1869>();
        list.add((class_1869) manager.method_8130(class_2960.method_60655("earlystage", "flint_axe")).get().comp_1933());
        list.add((class_1869) manager.method_8130(class_2960.method_60655("earlystage", "flint_hoe")).get().comp_1933());
        list.add((class_1869) manager.method_8130(class_2960.method_60655("earlystage", "flint_pickaxe")).get().comp_1933());
        list.add((class_1869) manager.method_8130(class_2960.method_60655("earlystage", "flint_shovel")).get().comp_1933());
        list.add((class_1869) manager.method_8130(class_2960.method_60655("earlystage", "flint_sword")).get().comp_1933());
        return list;
    }

}
