package net.earlystage.data;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.earlystage.EarlyStageMain;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class DataLoader implements SimpleSynchronousResourceReloadListener {

    private static final Logger LOGGER = LogManager.getLogger("EarlyStage");

    @Override
    public class_2960 getFabricId() {
        return class_2960.method_60655("earlystage", "loader");
    }

    @Override
    public void method_14491(class_3300 manager) {
        EarlyStageMain.SIEVE_DROP_TEMPLATES.clear();

        manager.method_14488("sieve_drops", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonObject data = JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject();

                for (int u = 0; u < data.getAsJsonArray("drops").size(); u++) {
                    JsonObject data2 = (JsonObject) data.getAsJsonArray("drops").get(u);
                    if (class_7923.field_41175.method_10223(class_2960.method_60654(data2.get("block_id").getAsString())) == class_2246.field_10124) {
                        LOGGER.warn("Block Id: " + data2.get("block_id").getAsString() + " is not a valid block id");
                        continue;
                    }

                    class_1792 blockItem = class_7923.field_41175.method_10223(class_2960.method_60654(data2.get("block_id").getAsString())).method_8389();

                    List<class_1792> blockDrops = new ArrayList<class_1792>();
                    List<Float> dropChances = new ArrayList<Float>();
                    List<Integer> rollCount = new ArrayList<Integer>();

                    if (class_3518.method_15258(data2, "replace", false)) {
                        for (int i = 0; i < EarlyStageMain.SIEVE_DROP_TEMPLATES.size(); i++)
                            if (EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockItem() == blockItem) {
                                EarlyStageMain.SIEVE_DROP_TEMPLATES.remove(i);
                                break;
                            }
                    } else {
                        // checks if it already exist
                        for (int i = 0; i < EarlyStageMain.SIEVE_DROP_TEMPLATES.size(); i++)
                            if (EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockItem() == blockItem) {
                                blockDrops.addAll(EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getBlockDrops());
                                dropChances.addAll(EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getDropChances());
                                rollCount.addAll(EarlyStageMain.SIEVE_DROP_TEMPLATES.get(i).getRollCount());
                                EarlyStageMain.SIEVE_DROP_TEMPLATES.remove(i);
                                break;
                            }
                    }

                    for (int i = 0; i < data2.getAsJsonArray("block_drops").size(); i++) {
                        JsonObject data3 = (JsonObject) data2.getAsJsonArray("block_drops").get(i);
                        blockDrops.add(class_7923.field_41178.method_10223(class_2960.method_60654(data3.get("item_id").getAsString())));
                        dropChances.add(data3.get("chance").getAsFloat());
                        rollCount.add(data3.get("rolls").getAsInt());
                    }
                    EarlyStageMain.SIEVE_DROP_TEMPLATES.add(new SieveDropTemplate(blockItem, blockDrops, dropChances, rollCount));
                }
            } catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", id.toString(), e.toString());
            }
        });

    }

}
