package net.earlystage.init;

import java.util.ArrayList;
import java.util.List;

import ht.treechop.api.TreeChopEvents;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1743;
import net.minecraft.class_1802;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_7923;

public class EventInit {

    private static final List<class_2960> leavesBlockList = new ArrayList<>();

    public static void init() {
        class_7923.field_41175.forEach((block) -> {
            if (block.method_26162().method_29177().method_12832().contains("leaves")) {
                leavesBlockList.add(block.method_26162().method_29177());
            }
        });
        RegistryEntryAddedCallback.event(class_7923.field_41175).register((rawId, id, block) -> {
            if (block.method_26162().method_29177().method_12832().contains("leaves")) {
                leavesBlockList.add(block.method_26162().method_29177());
            }
        });
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (leavesBlockList.contains(key.method_29177()) && ConfigInit.CONFIG.extraStickDropChance > 0.0001f) {
                // Missing Silk Touch check here
                class_55 pool = class_55.method_347().with(class_77.method_411(class_1802.field_8600).method_419()).method_352(class_40.method_273(1, ConfigInit.CONFIG.extraStickDropChance))
                        .method_356(class_223.method_945(class_2073.class_2074.method_8973().method_8977(class_1802.field_8868)).method_16780()).method_355();
                tableBuilder.pool(pool);
            }
        });

        if (FabricLoader.getInstance().isModLoaded("treechop")) {
            TreeChopEvents.BEFORE_CHOP.register((world, player, pos, state, chopData) -> player == null || player.method_6047().method_7909() instanceof class_1743);
        }
    }

}
