package net.earlystage.item;

import java.util.HashMap;
import java.util.Map;

import org.jetbrains.annotations.Nullable;

import net.earlystage.mixin.access.AxeItemAccessor;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5712;

public class BarkItem extends class_1792 {

    public static final Map<class_2248, class_1792> BARK_ITEMS = new HashMap<class_2248, class_1792>();
    public static final Map<class_2248, class_2248> STRIPPED_LOG_COMPAT = new HashMap<class_2248, class_2248>();
    private final class_2248 logBlock;
    @Nullable
    private final class_2248 woodBlock;

    public BarkItem(class_1793 settings, class_2248 logBlock, @Nullable class_2248 woodBlock, int cookTime) {
        super(settings);
        this.logBlock = logBlock;
        this.woodBlock = woodBlock;
        FuelRegistry.INSTANCE.add(this, cookTime);
        BarkItem.BARK_ITEMS.put(this.logBlock, this);
        if (this.woodBlock != null) {
            BarkItem.BARK_ITEMS.put(this.woodBlock, this);
        }
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (blockState.method_26164(class_3481.field_15475)) {
            if ((AxeItemAccessor.getStrippedBlocks().containsValue(block)
                    && (AxeItemAccessor.getStrippedBlocks().get(logBlock) == block || (woodBlock != null && AxeItemAccessor.getStrippedBlocks().get(woodBlock) == block))) ||
                    (STRIPPED_LOG_COMPAT.containsValue(block)
                            && (STRIPPED_LOG_COMPAT.get(logBlock) == block || (woodBlock != null && STRIPPED_LOG_COMPAT.get(woodBlock) == block)))) {
                class_1657 playerEntity = context.method_8036();
                class_1799 itemStack = context.method_8041();
                if (playerEntity instanceof class_3222 serverPlayerEntity) {
                    class_174.field_24478.method_23889(serverPlayerEntity, blockPos, itemStack);
                }
                world.method_8396(null, blockPos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);

                if (!world.method_8608()) {
                    class_2680 blockState2 = AxeItemAccessor.getStrippedBlocks().get(logBlock) == block ? logBlock.method_9564().method_11657(class_2465.field_11459, blockState.method_11654(class_2465.field_11459))
                            : woodBlock.method_9564();
                    world.method_8652(blockPos, blockState2, class_2248.field_31036 | class_2248.field_31030);
                    world.method_43276(class_5712.field_28733, blockPos, class_5712.class_7397.method_43286(playerEntity, blockState2));
                    if (playerEntity != null && !playerEntity.method_7337()) {
                        itemStack.method_7934(1);
                    }
                }
                return class_1269.method_29236(world.method_8608());
            }

        }
        return super.method_7884(context);
    }

}
