package net.earlystage.item;

import net.earlystage.init.ItemInit;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_5633;
import net.minecraft.class_5712;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class BrickBucketItem extends class_1792 implements class_5633 {
    private final class_3611 fluid;

    public BrickBucketItem(class_3611 fluid, class_1792.class_1793 settings) {
        super(settings);
        this.fluid = fluid;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_3965 blockHitResult = BrickBucketItem.method_7872(world, user, this.fluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348);
        if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430(itemStack);
        }
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = blockHitResult.method_17777();
            class_2350 direction = blockHitResult.method_17780();
            class_2338 blockPos2 = blockPos.method_10093(direction);
            if (!world.method_8505(user, blockPos) || !user.method_7343(blockPos2, direction, itemStack)) {
                return class_1271.method_22431(itemStack);
            }
            if (this.fluid == class_3612.field_15906) {
                class_2680 blockState = world.method_8320(blockPos);
                if (blockState.method_26204() instanceof class_2263 && !blockState.method_26227().method_15769() && blockState.method_26227().method_15771()
                        && (blockState.method_26227().method_15767(class_3486.field_15517) || blockState.method_26227().method_15767(class_3486.field_15518))) {
                    user.method_7259(class_3468.field_15372.method_14956(this));
                    class_1799 itemStack2;
                    if (blockState.method_26227().method_15767(class_3486.field_15518)) {
                        world.method_8396(user, blockPos, class_3417.field_15202, class_3419.field_15245, 1.0f, 1.0f);
                        itemStack2 = new class_1799(ItemInit.LAVA_BRICK_BUCKET);
                    } else {
                        world.method_8396(user, blockPos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
                        itemStack2 = new class_1799(ItemInit.WATER_BRICK_BUCKET);
                    }
                    world.method_33596(user, class_5712.field_28167, blockPos);
                    class_1799 itemStack3 = class_5328.method_30012(itemStack, user, itemStack2);
                    if (!world.method_8608()) {
                        if (blockState.method_11654(class_2741.field_12508)) {
                            world.method_8652(blockPos, blockState.method_11657(class_2741.field_12508, false), class_2248.field_31036);
                        }else{
                            world.method_8652(blockPos, this.fluid.method_15785().method_15759(), class_2248.field_31022);
                        }
                        class_174.field_1208.method_8932((class_3222) user, itemStack2);
                    }
                    return class_1271.method_29237(itemStack3, world.method_8608());
                }
                return class_1271.method_22431(itemStack);
            }
            class_2680 blockState = world.method_8320(blockPos);
            class_2338 blockPos3 = blockState.method_26204() instanceof class_2402 && this.fluid == class_3612.field_15910 ? blockPos : blockPos2;
            if (this.method_7731(user, world, blockPos3, blockHitResult)) {
                this.method_7728(user, world, itemStack, blockPos3);
                if (user instanceof class_3222) {
                    class_174.field_1191.method_23889((class_3222) user, blockPos3, itemStack);
                }
                user.method_7259(class_3468.field_15372.method_14956(this));
                return class_1271.method_29237(BrickBucketItem.getEmptiedStack(itemStack, user, this.fluid), world.method_8608());
            }
            return class_1271.method_22431(itemStack);
        }
        return class_1271.method_22430(itemStack);
    }

    public static class_1799 getEmptiedStack(class_1799 stack, class_1657 player, class_3611 fluid) {
        if (!player.method_31549().field_7477) {
            if (fluid == class_3612.field_15908) {
                return new class_1799(class_1802.field_8162);
            }
            return new class_1799(ItemInit.BRICK_BUCKET);
        }
        return stack;
    }

    @Override
    public void method_7728(@Nullable class_1657 player, class_1937 world, class_1799 stack, class_2338 pos) {
    }

    @Override
    public boolean method_7731(@Nullable class_1657 player, class_1937 world, class_2338 pos, @Nullable class_3965 hitResult) {
        if (!(this.fluid instanceof class_3609)) {
            return false;
        }
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        boolean bl = blockState.method_26188(this.fluid);
        boolean bl2 = blockState.method_26215() || bl || block instanceof class_2402 fluidFillable && fluidFillable.method_10310(player, world, pos, blockState, this.fluid);
        if (!bl2) {
            return hitResult != null && this.method_7731(player, world, hitResult.method_17777().method_10093(hitResult.method_17780()), null);
        }
        if (world.method_8597().comp_644() && this.fluid.method_15791(class_3486.field_15517)) {
            int i = pos.method_10263();
            int j = pos.method_10264();
            int k = pos.method_10260();
            world.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.method_8406(class_2398.field_11237, (double) i + Math.random(), (double) j + Math.random(), (double) k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof class_2402 && this.fluid == class_3612.field_15910) {
            ((class_2402) block).method_10311(world, pos, blockState, ((class_3609) this.fluid).method_15729(false));
            this.playEmptyingSound(player, world, pos);
            return true;
        }
        if (!world.field_9236 && bl && !blockState.method_51176()) {
            world.method_22352(pos, true);
        }
        if (world.method_8652(pos, this.fluid.method_15785().method_15759(), class_2248.field_31036 | class_2248.field_31030) || blockState.method_26227().method_15771()) {
            this.playEmptyingSound(player, world, pos);
            return true;
        }
        return false;
    }

    private void playEmptyingSound(@Nullable class_1657 player, class_1936 world, class_2338 pos) {
        class_3414 soundEvent = this.fluid.method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        world.method_8396(player, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        if (this.fluid.method_15791(class_3486.field_15518) && player != null && !player.method_7337()) {
            world.method_8396(player, pos, class_3417.field_14821, class_3419.field_15248, 0.5f, 1.0f);
        }
        world.method_33596((class_1297) player, class_5712.field_28166, pos);
    }
}
