package net.earlystage.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

import org.jetbrains.annotations.Nullable;

import net.earlystage.init.RecipeInit;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7709;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ExtraBlastingRecipe implements class_1860<ExtraBlastingRecipeInput> {
    private final class_7709 category;
    private final String group;
    private final class_1856 input;
    private final class_1856 extraInput;
    private final class_1799 output;
    private final float experience;
    private final int cookTime;

    public ExtraBlastingRecipe(String group, class_7709 category, class_1856 input, class_1856 extraInput, class_1799 output, float experience, int cookTime) {
        this.category = category;
        this.group = group;
        this.input = input;
        this.extraInput = extraInput;
        this.output = output;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    @Override
    public class_1799 method_17447() {
        return new class_1799(class_2246.field_16333);
    }

    @Override
    public class_1865<?> method_8119() {
        return RecipeInit.EXTRA_BLASTING_SERIALIZER;
    }

    private boolean test(@Nullable class_1799 input, class_1856 ingredient) {
        if (input == null) {
            return false;
        }
        if (this.method_31584()) {
            return input.method_7960();
        }
        for (class_1799 itemStack2 : ingredient.method_8105()) {
            if (!itemStack2.method_31574(input.method_7909())) {
                continue;
            }
            if (input.method_7947() < itemStack2.method_7947()) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_2371<class_1856> method_8117() {
        class_2371<class_1856> defaultedList = class_2371.method_10211();
        defaultedList.add(this.input);
        defaultedList.add(this.extraInput);
        return defaultedList;
    }

    public float getExperience() {
        return this.experience;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    @Override
    public class_1799 method_8110(class_7874 wrapperLookup) {
        return this.output;
    }

    @Override
    public String method_8112() {
        return this.group;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public class_3956<?> method_17716() {
        return RecipeInit.EXTRA_BLASTING;
    }

    public class_7709 getCategory() {
        return this.category;
    }

    public static class Serializer implements class_1865<ExtraBlastingRecipe> {

        public static final MapCodec<ExtraBlastingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> recipe.group),
                class_7709.field_40245.fieldOf("category").orElse(class_7709.field_40244).forGetter(recipe -> recipe.category),
                class_1856.field_46096.fieldOf("ingredient").forGetter(recipe -> recipe.input),
                class_1856.field_46096.fieldOf("extraingredient").forGetter(recipe -> recipe.extraInput), class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.output),
                Codec.FLOAT.fieldOf("experience").orElse(Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)),
                Codec.INT.fieldOf("cookingtime").orElse(100).forGetter(recipe -> recipe.cookTime)).apply(instance, ExtraBlastingRecipe::new));

        public static final class_9139<class_9129, ExtraBlastingRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        @Override
        public MapCodec<ExtraBlastingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ExtraBlastingRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static ExtraBlastingRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7709 cookingRecipeCategory = buf.method_10818(class_7709.class);
            class_1856 input = class_1856.field_48355.decode(buf);
            class_1856 extraInput = class_1856.field_48355.decode(buf);
            class_1799 itemStack = (class_1799) class_1799.field_48349.decode(buf);
            float experience = buf.readFloat();
            int cookTime = buf.method_10816();
            return new ExtraBlastingRecipe(group, cookingRecipeCategory, input, extraInput, itemStack, experience, cookTime);
        }

        private static void write(class_9129 buf, ExtraBlastingRecipe extraBlastingRecipe) {
            buf.method_10814(extraBlastingRecipe.group);
            buf.method_10817(extraBlastingRecipe.getCategory());
            class_1856.field_48355.encode(buf, extraBlastingRecipe.input);
            class_1856.field_48355.encode(buf, extraBlastingRecipe.extraInput);
            class_1799.field_48349.encode(buf, extraBlastingRecipe.output);
            buf.method_52941(extraBlastingRecipe.experience);
            buf.method_10804(extraBlastingRecipe.cookTime);
        }

    }

    @Override
    public boolean matches(ExtraBlastingRecipeInput extraBlastingRecipeInput, class_1937 world) {
        return this.input.method_8093(extraBlastingRecipeInput.input()) && test(extraBlastingRecipeInput.extraInput(), this.extraInput);
    }

    @Override
    public class_1799 craft(ExtraBlastingRecipeInput extraBlastingRecipeInput, class_7874 wrapperLookup) {
        return this.output.method_7972();
    }

}
